% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts-package.R
\docType{package}
\name{sts-package}
\alias{sts-package}
\title{A Structural Topic and Sentiment-Discourse Model for Text Analysis}
\description{
This package implements the Structural Topic and Sentiment-Discourse  
(STS) model, which allows researchers to estimate topic models with 
document-level metadata that determines both topic prevalence and 
sentiment-discourse. The sentiment-discourse is modeled as a document-level 
latent variable for each topic that modulates the word frequency within a 
topic. These latent topic sentiment-discourse variables are controlled by 
the document-level metadata. The STS model can be useful for regression 
analysis with text data in addition to topic modeling's traditional 
use of descriptive analysis.
}
\details{
Function to fit the model: \code{\link{sts}} 

Functions for Post-Estimation: \code{\link{estimateRegnTables}}
\code{\link{exclusivitySTS}} \code{\link{semanticCoherenceSTS}}
 \code{\link{heldoutLikelihood}}
}
\references{
Chen L. and Mankad, S. (forthcoming) "A Structural Topic and 
Sentiment-Discourse Model for Text Analysis" Management Science.
}
\seealso{
\code{\link{sts}}
}
\author{
Author: Shawn Mankad and Li Chen

Maintainer: Shawn Mankad <smankad@ncsu.edu>
}
\keyword{package}
