% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prim.R
\name{prim.diversify}
\alias{prim.diversify}
\title{PRIM diversify strategy}
\usage{
prim.diversify(formula, data, X, y, n, peeling.quantile = 0.03,
  min.support = 0.05, max.peel = 0.1, train.fraction = 0.66,
  quality.function = base::mean, plot = FALSE, parallel = TRUE,
  minimize = FALSE, optimal.box = c("best", "2se"))
}
\arguments{
\item{formula}{Formula with a response and terms}

\item{data}{Data frame to find rules in}

\item{X}{Optionally instead of using a formula: Data frame to find rules in}

\item{y}{Optionally instead of using a formula: Response vector, usually of type numeric}

\item{n}{Numer of attempts to run the PRIM algorithm}

\item{peeling.quantile}{Quantile to peel off for numerical variables}

\item{min.support}{Minimal size of a box to be valid}

\item{max.peel}{Maximal size of a peel, as a fraction. Defaults to 0.1}

\item{train.fraction}{Train-test split fraction used in validation, defaults to 0.66}

\item{quality.function}{Function to use for determining subset quality, defaults to mean}

\item{plot}{Plot intermediate results, defaults to false. Note that intermediate plotting is unavailable when running in parallel}

\item{parallel}{Compute each run in parallel, defaults to TRUE. This will use all but one core. Note that intermediate plotting is unavailable when running in parallel}

\item{minimize}{Should the quality be minimized? Same as setting the quality function to function(x){-quality.function(x)}. Defaults to FALSE}

\item{optimal.box}{During validation, choose the box with the highest quality or a simpler box, two standard errors from the optimum}
}
\value{
An S3 object of type prim.diversify
}
\description{
Provide a (hopefully) diverse number of box definitions
}
\details{
Because the final box depends on the data used, we re-run the PRIM peeling algorithm multiple times, each with a different random train/test split. Each run is independent from the others, so this algorithm is run in parallel by default.
}
\examples{
  data(ames)
  p.div <- prim.diversify(
      SalePrice ~ . - PID - Order,
      data = ames,
      n = 3,
      plot = TRUE,
      parallel = FALSE,
      optimal.box = "best"
  )

  \donttest{
  summary(p.div)
  plot(p.div)
  }
}
\author{
Jurian Baas
}
