% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prim.R
\name{predict.prim.peel}
\alias{predict.prim.peel}
\title{Validate peels}
\usage{
\method{predict}{prim.peel}(object, newdata, ...)
}
\arguments{
\item{object}{An S3 object of class prim.peel}

\item{newdata}{A data frame in which to look for variables with which to predict}

\item{...}{further arguments passed to or from other methods}
}
\value{
An S3 object of type prim.predict
}
\description{
Validate the results taken from the PRIM peeling process
}
\details{
This function takes the result of the prim peeling process and applies it to new data. Usually the optimal box in the peeling process is not the best on unobserved data.
}
\examples{
\donttest{
  data(ames)
  ames.sample <- sample(nrow(ames), nrow(ames) * 0.75)
  ames <- prim.data.prepare(ames)
  ames.model <- prim(SalePrice ~ . - PID - Order, ames[ames.sample,])
  ames.predict <- predict(ames.model, ames[-ames.sample,])
  plot(ames.model)
  plot(ames.predict)
}
}
\author{
Jurian Baas
}
