% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prim.R
\name{prim.box.index}
\alias{prim.box.index}
\title{Prim Box Index}
\usage{
prim.box.index(object, newdata, box.index)
}
\arguments{
\item{object}{An S3 object of class prim.peel or prim.predict}

\item{newdata}{A data frame on which to apply the conditions}

\item{box.index}{Optionally, the index of the peel which defines the box. If not provided, the simplest box with the highest quality is used}
}
\value{
A vector of indices
}
\description{
For a given box (defined as a set of peels) id, return the index of those rows that satisfy all conditions of the box
}
\examples{
\donttest{
  data(pima)
  pima.sample <- sample(nrow(pima), 0.75*nrow(pima))
  pima <- prim.data.prepare(pima)
  pima.model <- prim(class ~ ., data = pima[pima.sample,],
    peeling.quantile = 0.4, min.support = 0.4)
  pima.predict <- predict(pima.model, pima[-pima.sample,])
  pima.idx <- prim.box.index(pima.predict, pima)
}
}
\author{
Jurian Baas
}
