% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.subspace_clustering}
\alias{plot}
\alias{plot.subspace_clustering}
\title{Plotting Subspace Clusterings}
\usage{
\method{plot}{subspace_clustering}(x, data, color_by = "mix",
  standardcolors = c("#1F77B4", "#FF7F0E", "#2CA02C", "#D62728", "#9467BD",
  "#8C564B", "#E377C2", "#7F7F7F", "#BCBD22", "#17BECF", "#000000"),
  tooltip_on = "hover", ...)
}
\arguments{
\item{x}{an S3-Object of type \emph{subspace_clustering} as generated by any of the functions of the \emph{subspace} package}

\item{data}{The original data matrix on which the clustering was performed.}

\item{color_by}{a parameter indicating how a point that is in multiple clusters should be colored.
If "mix" is selected, the point will be colored as a mixture of the colors of both of the clusters that the point is in.
If "any" is selected, a random color is selected from the colors of all the clusters that the point is in.}

\item{standardcolors}{a vector of strings representing HTML-Colors that will be used to color the points by cluster assignment.
Noise will be colored with the last color in the vector.}

\item{tooltip_on}{decides if tooltips should be shown on "hover" or on "click"}

\item{...}{this is passed on to ggvis::layer_points and can be used to change, for example the size of the points}
}
\value{
a ggvis object. If the return value is not used, a plot will be shown, but the returned plot can also be altered using ggvis
}
\description{
Plotting for Subspace clusterings as generated by the package \emph{subspace}.



Generates a 2d-scatterplot with interactive controls to select the dimensions that should be plotted.\cr
           This visualization is created using the ggvis package and is therefore also compatible with shiny.
}
\note{
When passing ellipsis parameters, the ":=" syntax from ggvis may get in your way, but you can work around this by
     manually creating a props object as seen in the example.
}
\examples{
#Load the example dataset for this package
data("subspace_dataset")
#Load the true clustering for this dataset
path_to_clustering <- paste(path.package("subspace"),"/extdata/subspace_dataset.true",sep="")
clustering <- clustering_from_file(file_path=path_to_clustering)
#also generate a clustering with one of the algorithms
clustering2 <- CLIQUE(subspace_dataset,tau=0.2)

#now plot the generated clustering
plot(clustering2,subspace_dataset)
#plot the true clustering with small points
plot(clustering,subspace_dataset,size=0.1)

#Now plot the points with a different shape.
#This requires the workaround that was discussed in "Notes"
p <- ggvis::prop(property="shape",x="cross")
plot(clustering,subspace_dataset,props=p)
}

