/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers;

import java.util.LinkedList;
import java.util.Random;
import moa.cluster.Clustering;
import moa.clusterers.Clusterer;
import moa.core.InstancesHeader;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.core.StringUtils;
import moa.gui.AWTRenderer;
import moa.options.AbstractOptionHandler;
import moa.options.FlagOption;
import moa.options.IntOption;
import moa.tasks.TaskMonitor;
import weka.core.Instance;
import weka.core.Instances;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractClusterer
extends AbstractOptionHandler
implements Clusterer {
    protected InstancesHeader modelContext;
    protected double trainingWeightSeenByModel = 0.0;
    protected int randomSeed = 1;
    protected IntOption randomSeedOption;
    public FlagOption evaluateMicroClusteringOption;
    protected Random clustererRandom;
    protected Clustering clustering;

    public String getPurposeString() {
        return "MOA Clusterer: " + this.getClass().getCanonicalName();
    }

    public AbstractClusterer() {
        if (this.isRandomizable()) {
            this.randomSeedOption = new IntOption("randomSeed", 'r', "Seed for random behaviour of the Clusterer.", 1);
        }
        if (this.implementsMicroClusterer()) {
            this.evaluateMicroClusteringOption = new FlagOption("evaluateMicroClustering", 'M', "Evaluate the underlying microclustering instead of the macro clustering");
        }
    }

    public void prepareForUseImpl(TaskMonitor taskMonitor, ObjectRepository objectRepository) {
        if (this.randomSeedOption != null) {
            this.randomSeed = this.randomSeedOption.getValue();
        }
        if (!this.trainingHasStarted()) {
            this.resetLearning();
        }
        this.clustering = new Clustering();
    }

    public void setModelContext(InstancesHeader instancesHeader) {
        if (instancesHeader != null && instancesHeader.classIndex() < 0) {
            throw new IllegalArgumentException("Context for a Clusterer must include a class to learn");
        }
        if (this.trainingHasStarted() && this.modelContext != null && (instancesHeader == null || !AbstractClusterer.contextIsCompatible((InstancesHeader)this.modelContext, (InstancesHeader)instancesHeader))) {
            throw new IllegalArgumentException("New context is not compatible with existing model");
        }
        this.modelContext = instancesHeader;
    }

    public InstancesHeader getModelContext() {
        return this.modelContext;
    }

    public void setRandomSeed(int n) {
        this.randomSeed = n;
        if (this.randomSeedOption != null) {
            this.randomSeedOption.setValue(n);
        }
    }

    public boolean trainingHasStarted() {
        return this.trainingWeightSeenByModel > 0.0;
    }

    public double trainingWeightSeenByModel() {
        return this.trainingWeightSeenByModel;
    }

    public void resetLearning() {
        this.trainingWeightSeenByModel = 0.0;
        if (this.isRandomizable()) {
            this.clustererRandom = new Random(this.randomSeed);
        }
        this.resetLearningImpl();
    }

    public void trainOnInstance(Instance instance) {
        if (instance.weight() > 0.0) {
            this.trainingWeightSeenByModel += instance.weight();
            this.trainOnInstanceImpl(instance);
        }
    }

    public Measurement[] getModelMeasurements() {
        Measurement[] measurementArray;
        LinkedList<Measurement> linkedList = new LinkedList<Measurement>();
        linkedList.add(new Measurement("model training instances", this.trainingWeightSeenByModel()));
        linkedList.add(new Measurement("model serialized size (bytes)", (double)this.measureByteSize()));
        Measurement[] measurementArray2 = this.getModelMeasurementsImpl();
        if (measurementArray2 != null) {
            measurementArray = measurementArray2;
            int n = measurementArray.length;
            for (int i = 0; i < n; ++i) {
                Measurement measurement = measurementArray[i];
                linkedList.add(measurement);
            }
        }
        if ((measurementArray = this.getSubClusterers()) != null && measurementArray.length > 0) {
            LinkedList<Measurement[]> linkedList2 = new LinkedList<Measurement[]>();
            Measurement[] measurementArray3 = measurementArray;
            int n = measurementArray3.length;
            for (int i = 0; i < n; ++i) {
                Measurement measurement = measurementArray3[i];
                if (measurement == null) continue;
                linkedList2.add(measurement.getModelMeasurements());
            }
            for (Measurement measurement : measurementArray3 = Measurement.averageMeasurements((Measurement[][])((Measurement[][])linkedList2.toArray((T[])new Measurement[linkedList2.size()][])))) {
                linkedList.add(measurement);
            }
        }
        return linkedList.toArray(new Measurement[linkedList.size()]);
    }

    public void getDescription(StringBuilder stringBuilder, int n) {
        StringUtils.appendIndented((StringBuilder)stringBuilder, (int)n, (String)"Model type: ");
        stringBuilder.append(this.getClass().getName());
        StringUtils.appendNewline((StringBuilder)stringBuilder);
        Measurement.getMeasurementsDescription((Measurement[])this.getModelMeasurements(), (StringBuilder)stringBuilder, (int)n);
        StringUtils.appendNewlineIndented((StringBuilder)stringBuilder, (int)n, (String)"Model description:");
        StringUtils.appendNewline((StringBuilder)stringBuilder);
        if (this.trainingHasStarted()) {
            this.getModelDescription(stringBuilder, n);
        } else {
            StringUtils.appendIndented((StringBuilder)stringBuilder, (int)n, (String)"Model has not been trained.");
        }
    }

    public Clusterer[] getSubClusterers() {
        return null;
    }

    public Clusterer copy() {
        return (Clusterer)super.copy();
    }

    public String getClassNameString() {
        return InstancesHeader.getClassNameString((InstancesHeader)this.modelContext);
    }

    public String getClassLabelString(int n) {
        return InstancesHeader.getClassLabelString((InstancesHeader)this.modelContext, (int)n);
    }

    public String getAttributeNameString(int n) {
        return InstancesHeader.getAttributeNameString((InstancesHeader)this.modelContext, (int)n);
    }

    public String getNominalValueString(int n, int n2) {
        return InstancesHeader.getNominalValueString((InstancesHeader)this.modelContext, (int)n, (int)n2);
    }

    public static boolean contextIsCompatible(InstancesHeader instancesHeader, InstancesHeader instancesHeader2) {
        if (instancesHeader2.numClasses() < instancesHeader.numClasses()) {
            return false;
        }
        if (instancesHeader2.numAttributes() < instancesHeader.numAttributes()) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        while (n < instancesHeader.numAttributes() && (n != instancesHeader.classIndex() || ++n < instancesHeader.numAttributes())) {
            if (n2 == instancesHeader2.classIndex()) {
                ++n2;
            }
            if (instancesHeader.attribute(n).isNominal()) {
                if (!instancesHeader2.attribute(n2).isNominal()) {
                    return false;
                }
                if (instancesHeader2.attribute(n2).numValues() < instancesHeader.attribute(n).numValues()) {
                    return false;
                }
            } else {
                assert (instancesHeader.attribute(n).isNumeric());
                if (!instancesHeader2.attribute(n2).isNumeric()) {
                    return false;
                }
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public AWTRenderer getAWTRenderer() {
        return null;
    }

    public abstract void resetLearningImpl();

    public abstract void trainOnInstanceImpl(Instance var1);

    protected abstract Measurement[] getModelMeasurementsImpl();

    public abstract void getModelDescription(StringBuilder var1, int var2);

    protected static int modelAttIndexToInstanceAttIndex(int n, Instance instance) {
        return instance.classIndex() > n ? n : n + 1;
    }

    protected static int modelAttIndexToInstanceAttIndex(int n, Instances instances) {
        return instances.classIndex() > n ? n : n + 1;
    }

    public boolean implementsMicroClusterer() {
        return false;
    }

    public boolean keepClassLabel() {
        return false;
    }

    public Clustering getMicroClusteringResult() {
        return null;
    }
}

