% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_grid.R
\name{create_grid}
\alias{create_grid}
\title{Create a grid of evenly spaced points to allow hexagons to tesselate}
\usage{
create_grid(centroids, hex_size, buffer_dist, verbose = FALSE)
}
\arguments{
\item{centroids}{data frame of centroids to be allocated}

\item{hex_size}{a float value in degrees for the diameter of the hexagons}

\item{buffer_dist}{distance to extend beyond the geometry provided}

\item{verbose}{a boolean to indicate whether to show function progress}
}
\value{
grid
}
\description{
This function takes the bounding box of a group of polygons, or a specific
table of minimum and maximum longitudes and latitudes to create points
for each polygon to be allocated to that will tesselate into hexagons.
}
\examples{
# Create a set of centroids for grid to overlay
centroids <- create_centroids(tas_lga, "LGA_CODE16")
# Create the grid
grid <- create_grid(centroids = centroids, hex_size = 0.2, buffer_dist = 1.2, verbose = FALSE)
}
