% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{zap_attr}
\alias{zap_attr}
\title{Remove Attributes to Get a Simplified Object}
\usage{
zap_attr(x, except = c("dim", "dimnames"))
}
\arguments{
\item{x}{An object with attributes}

\item{except}{Character. A vector of attribute names to preserve. By default,
\dQuote{dim} and \dQuote{dimnames} are preserved.}
}
\description{
Get rid of summarytools-specific attributes to get a simple data structure
(matrix, array, ...), which can be easily manipulated.
}
\details{
If the object contains grouped results:
\itemize{
 \item The inner objects will lose their attributes
 \item The \dQuote{stby} class will be replaced with \dQuote{by}
 \item The \dQuote{dim} and \dQuote{dimnames} attributes will be set to
   available relevant values, but expect slight differences between objects
   created with \code{stby()} \emph{vs} \code{group_by()}.
}
}
\examples{
data(tobacco)
descr(tobacco) |> zap_attr()
freq(tobacco$gender) |> zap_attr()
}
