% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMTrainer.R
\docType{data}
\name{LMTrainer}
\alias{LMTrainer}
\title{Linear Models Trainer}
\format{\code{\link{R6Class}} object.}
\usage{
LMTrainer
}
\description{
Trains linear models such as Logistic, Lasso or Ridge regression model. It uses glmnet R package in the backend. Lasso regression can be used
as a variable selection method also. This class provides fit, predict, cross valdidation functions.
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
bst = LMTrainer$new(family, weights, alpha, nlambda, standardize.response)
bst$fit(X_train, "target")
prediction <- bst$predict(X_test)
bst$cv_model(X_train, "target", nfolds=4, parallel=TRUE)
cv_prediction <- bst$cv_predict(X_test)
}
}

\section{Methods}{

\describe{
  \item{\code{$new()}}{Initialises an instance of random forest model}
  \item{\code{$fit()}}{fit model to an input train data (data frame or data table) and trains the model.}
  \item{\code{$predict()}}{returns predictions by fitting the trained model on test data.}
  \item{\code{$cv_model()}}{Using k-fold cross validation technique, finds the best value of lambda. type.measure is the loss to use for cross validation.}
  \item{\code{$cv_predict()}}{Using the best value of lambda, makes predictions on the test data}
  \item{\code{$get_importance()}}{Returns a matrix of feature coefficients as generated by Lasso}
}
}

\section{Arguments}{

\describe{
 \item{family}{type of regression to perform, values can be "gaussian" ,"binomial", "multinomial","mgaussian"}
 \item{weights}{observation weights. Can be total counts if responses are proportion matrices. Default is 1 for each observation}
 \item{alpha}{The elasticnet mixing parameter, alpha=1 is the lasso penalty, and alpha=0 the ridge penalty.}
 \item{nlambda}{the number of lambda values - default is 100}
 \item{standardize.response}{This is for the family="mgaussian" family, and allows the user to standardize the response variables}
}
}

\examples{
LINK <- "http://archive.ics.uci.edu/ml/machine-learning-databases/housing/housing.data"
housing <- read.table(LINK)
names <- c("CRIM","ZN","INDUS","CHAS","NOX","RM","AGE","DIS",
           "RAD","TAX","PTRATIO","B","LSTAT","MEDV")
names(housing)  <-  names
lf <- LMTrainer$new(family = 'gaussian', alpha=1)
lf$fit(X = housing, y = 'MEDV')
predictions <- lf$predict(df = housing)


# cross validation model
lf$cv_model(X = housing, y = 'MEDV', nfolds = 5, parallel = FALSE)
predictions <- lf$cv_predict(df = housing)
coefs <- lf$get_importance()
}
\keyword{datasets}
