% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MoE_Y.R
\name{MoE_Y}
\alias{MoE_Y}
\title{Margin of error for count}
\usage{
MoE_Y(P = 0.5, n, pop, confidence = 0.95, R = 1, deff_sam = 1,
  deff_est = 1)
}
\arguments{
\item{P}{The expected proportion for variable of interest.}

\item{n}{The expected sample size.}

\item{pop}{Population size.}

\item{confidence}{Optional positive value for confidence interval. This variable by default is 0.95.}

\item{R}{The expected response rate (optional). If not defined, it is assumed to be 1 (full-response).}

\item{deff_sam}{The expected design effect of sample design for the estimates (optional). If not defined, it is assumed to be 1.}

\item{deff_est}{The estimated design effect of estimator for the estimates (optional). If not defined, it is assumed to be 1.}
}
\value{
The estimate of margin of error for count.
}
\description{
The function computes margin of error for count. The calculation takes into proportion, expected response rate and design effect.
}
\examples{
library(data.table)
n <- 100
pop <- 1000

MoE_Y(P = 0.5, n = n, pop = pop)

DT <- data.table(P = seq(0, 1, 0.01))
DT[, Y := round(pop * P)]
DT[, AMoE := MoE_Y(P, n = 100, pop = 1000)]
DT[Y > 0, RMoE := AMoE / Y]
DT

}
\seealso{
\code{\link{expvar}}, \code{\link{optsize}}, \code{\link{MoE_P}}
}
\keyword{surveysampling}
