\name{survivalBIV-package}
\alias{survivalBIV-package}
\alias{survivalBIV}
\docType{package}
\title{Estimation of the Bivariate Distribution Function}
\description{The \pkg{survivalBIV} software contains functions that calculate estimates for the bivariate distribution function. This package can be used to implement four methods. One of these estimators is the conditional Kaplan-Meier estimator, based on Bayes' theorem and Kaplan-Meier estimator (CKM); also, two recent estimators based on the Kaplan-Meier weights pertaining to the distribution of the total time (KMW). It also implements the inverse probability of censoring weighted estimator (IPCW). }

%\details{
%\tabular{ll}{
%Package: \tab survivalBIV\cr
%Type: \tab Package\cr
%Version: \tab 1.0\cr
%Date: \tab 2011-01-18\cr
%License: \tab What license is it under?\cr
%LazyLoad: \tab yes\cr
%}
%~~ An overview of how to use the package, including the most important functions ~~
%}
\author{Ana Moreira and Luis Meira Machado \email{lmachado@math.uminho.pt}

Maintainer: Ana Moreira <id2809@alunos.uminho.pt>
}

\references{
%~~ Literature or other references for background information ~~
de Una-Alvarez J, Amorim AP (2011). "A Semiparametric Estimator of the Bivariate Distribution Function for Censored Gap Times", \emph{Biometrical Journal}.

de Una-Alvarez J, Meira Machado LF (2008). "A Simple Estimator of the Bivariate Distribution Function for Censored Gap Times", \emph{Statistical and Probability Letters}, \bold{78}, 2440-2445.

Lin D, Sun W, Ying Z (1999). "Nonparametric Estimation of the Time Distributions for Serial Events with Censored Data", \emph{Biometrika}, \bold{86}, 59-70.

Meira Machado LF, Moreira A (2010). "Estimation of the Bivariate Distribution Function for Censored Gap Times". \emph{Proceedings of the 19th International Conference on Computational Statistics, pp. 1367-1374}.
}
%~~ Optionally other standard keywords, one per line, from file KEYWORDS in the R documentation directory ~~
%\keyword{ package }
%\seealso{
%~~ Optional links to other man pages, e.g. ~~
%~~ \code{\link[<pkg>:<pkg>-package]{<pkg>}} ~~
%}
%\examples{
%~~ simple examples of the most important functions ~~
%}
