% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnnsurv.R
\name{predict.dnnsurv}
\alias{predict.dnnsurv}
\title{Predict Method for DNNSurv}
\usage{
\method{predict}{dnnsurv}(
  object,
  newdata,
  batch_size = 32L,
  verbose = 0L,
  steps = NULL,
  callbacks = NULL,
  type = c("survival", "risk", "all"),
  distr6 = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{(dnnsurv(1))}\cr
Object of class inheriting from \code{"dnnsurv"}.}

\item{newdata}{\code{(data.frame(1))}\cr
Testing data of \code{data.frame} like object, internally is coerced with \code{\link[stats:model.matrix]{stats::model.matrix()}}.
If missing then training data from fitted object is used.}

\item{batch_size}{\code{(integer(1))}\cr
Passed to \link[keras:predict.keras.engine.training.Model]{keras::predict.keras.engine.training.Model}, elements in each batch.}

\item{verbose}{\code{(integer(1))}\cr
Level of verbosity for printing, \code{0} or \code{1}.}

\item{steps}{\code{(integer(1))}\cr
Number of batches before evaluation finished, see \link[keras:predict.keras.engine.training.Model]{keras::predict.keras.engine.training.Model}.}

\item{callbacks}{\code{(list())}\cr
Optional callbacks to apply during prediction.}

\item{type}{(\code{character(1)})\cr
Type of predicted value. Choices are survival probabilities over all time-points in training
data (\code{"survival"}) or a relative risk ranking (\code{"risk"}), which is the negative mean survival
time so higher rank implies higher risk of event, or both (\code{"all"}).}

\item{distr6}{\code{(logical(1))}\cr
If \code{FALSE} (default) and \code{type} is \code{"survival"} or \code{"all"} returns matrix of survival
probabilities, otherwise returns a \code{\link[distr6:Matdist]{distr6::Matdist()}}.}

\item{...}{\code{ANY} \cr
Currently ignored.}
}
\value{
A \code{numeric} if \code{type = "risk"}, a \code{\link[distr6:Matdist]{distr6::Matdist()}} (if \code{distr6 = TRUE})
and \code{type = "survival"}; a \code{matrix} if (\code{distr6 = FALSE}) and \code{type = "survival"} where
entries are survival probabilities with rows of observations and columns are time-points;
or a list combining above if \code{type = "all"}.
}
\description{
Predicted values from a fitted object of class dnnsurv.
}
\examples{
\donttest{
if (requireNamespaces(c("keras", "pseudo")))
  fit <- dnnsurv(data = simsurvdata(10))

  # predict survival matrix and relative risks
  predict(fit, simsurvdata(10), type = "all")

  # return as distribution
  if (requireNamespaces("distr6")) {
    predict(fit, simsurvdata(10), distr6 = TRUE)
  }
}

}
