% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_pycox.R
\name{get_pycox_callbacks}
\alias{get_pycox_callbacks}
\title{Get Torchtuples Callbacks}
\usage{
get_pycox_callbacks(
  early_stopping = FALSE,
  best_weights = FALSE,
  min_delta = 0,
  patience = 10L
)
}
\arguments{
\item{early_stopping}{\code{(logical(1))} \cr
If \code{TRUE} then constructs \verb{torchtuples.callbacks,EarlyStopping}.}

\item{best_weights}{\code{(logical(1))}\cr
If \code{TRUE} then returns \code{torchtuples.callbacks.BestWeights}. Ignored if \code{early_stopping}
is \code{TRUE}.}

\item{min_delta}{\code{(numeric(1))}\cr
Passed to \code{torchtuples.callbacks.EarlyStopping}.}

\item{patience}{\code{(integer(1))}\cr
Passed to \code{torchtuples.callbacks.EarlyStopping}.}
}
\description{
Helper function to return torchtuples callbacks from \code{torchtuples.callbacks}.
}
\examples{
\donttest{
if (requireNamespaces("reticulate")) {
  get_pycox_callbacks(early_stopping = TRUE)

  get_pycox_callbacks(best_weights = TRUE)
}
}

}
