% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_group_by.R
\name{surv_group_by}
\alias{surv_group_by}
\title{Create a Grouped Dataset for Survival Analysis}
\usage{
surv_group_by(data, grouping.vars)
}
\arguments{
\item{data}{a data frame}

\item{grouping.vars}{a character vector containing the name of grouping
variables. Should be of length <= 2}
}
\value{
Returns an object of class \code{surv_group_by} which is a
  \link[tibble]{tibble} data frame with the following components: \itemize{
  \item one column for each grouping variables. Contains the levels. \item a
  coumn named "data", which is a named list of data subsets created by the
  grouping variables. The list names are created by concatening the levels of
  grouping variables. }
}
\description{
Split a data frame into multiple new data frames based on one or
  two grouping variables. The \code{surv_group_by()} function takes an
  existing data frame and converts it into a grouped data frame where
  survival analysis are performed "by group".
}
\examples{
library("survival")
library("magrittr")

# Grouping by one variables: treatment "rx"
#::::::::::::::::::::::::::::::::::::::::::
grouped.d <- colon \%>\%
  surv_group_by("rx")

grouped.d # print

grouped.d$data # Access to the data

# Grouping by two variables
#::::::::::::::::::::::::::::::::::::::::::
grouped.d <- colon \%>\%
   surv_group_by(grouping.vars = c("rx", "adhere"))
   grouped.d

}
