% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz.R
\name{Gompertz}
\alias{Gompertz}
\alias{dgompertz}
\alias{gompertz}
\alias{pgompertz}
\alias{qgompertz}
\alias{hgompertz}
\alias{Hgompertz}
\alias{rgompertz}
\title{The Gompertz Distribution}
\usage{
dgompertz(x, alpha = 1, gamma = 1, log = FALSE, ...)

pgompertz(q, alpha = 1, gamma = 1, lower.tail = TRUE, log.p = FALSE, ...)

qgompertz(p, alpha = 1, gamma = 1, lower.tail = FALSE, log.p = FALSE, ...)

rgompertz(n, alpha = 1, gamma = 1, ...)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{alpha}{shape parameter of the  distribution (alpha > 0).}

\item{gamma}{scale parameter of the  distribution (gamma > 0).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{...}{further arguments passed to other methods.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}; otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of random values to return.}
}
\value{
dgompertz gives the (log) probability function, pgompertz gives the (log) distribution function, qgompertz gives the quantile function, and rgompertz generates random deviates.
}
\description{
Probability function, distribution function, quantile function and random generation for the  distribution with parameters alpha and gamma.
}
\details{
Probability density function:
\deqn{
f(x|\alpha, \gamma) = \alpha\gamma \exp\{\gamma x - \alpha(e^{\gamma x} - 1)\}I_{[0, \infty)}(x),
}
for \eqn{\alpha>0} and \eqn{\gamma>0}.

Distribution function:
\deqn{
F(x|\alpha, \gamma) = 1 - \exp\{- \alpha(e^{\gamma x} - 1)\},
}
for \eqn{x>0}, \eqn{\alpha>0} and \eqn{\gamma>0}.
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
