% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{confint.tp.survtmle}
\alias{confint.tp.survtmle}
\title{confint.tp.survtmle}
\usage{
\method{confint}{tp.survtmle}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{tp.survtmle}, as produced by invoking
the function \code{timepoints} on an object produced by \code{survtmle}, for
which a confidence interval is to be computed.}

\item{parm}{A numeric vector indicating which indexes of \code{object$est} to
return confidence intervals for (default is to return all). NOT USED NOW.}

\item{level}{A \code{numeric} indicating the level of the confidence interval
to be computed.}

\item{...}{Other arguments. Not currently used.}
}
\value{
A list of matrices, each with columns giving the lower and upper
 confidence limits for each parameter. These will be labeled as (1-level)/2
 and 1 - (1-level)/2 in percent. The default is 2.5% and 97.5%. The list
 contains as many matrices as their are comparison groups in the input data.
}
\description{
Computes confidence intervals for a fitted \code{tp.survtmle} object.
}
\examples{
# simulate data
set.seed(1234)
n <- 100
ftime <- round(runif(n, 1, 4))
ftype <- round(runif(n, 0, 2))
trt <- rbinom(n, 1, 0.5)
adjustVars <- data.frame(W1 = rnorm(n), W2 = rnorm(n))

# fit a survtmle object
fit <- survtmle(ftime = ftime, ftype = ftype, trt = trt,
                adjustVars = adjustVars, glm.trt = "W1 + W2",
                glm.ftime = "trt + W1 + W2", glm.ctime = "trt + W1 + W2",
                method = "mean", t0 = 4)
# extract cumulative incidence at each timepoint
tpfit <- timepoints(fit, times = seq_len(4))
# get confidence intervals
ci <- confint(tpfit)
ci
}
