% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_logrank_res.R
\name{get_logrank_res}
\alias{get_logrank_res}
\title{Run Log-Rank Test}
\usage{
get_logrank_res(in.formula, in.df, return.p = FALSE)
}
\arguments{
\item{in.formula}{Survival model formula. Can extract from an existing 
survfit object with formula(survfit).}

\item{in.df}{data.frame Corresponding data for the survival model.}

\item{return.p}{If set to TRUE, return only the log rank p-value.}
}
\value{
Results of survdiff or a log rank p-value if return.p is set to 
  TRUE.
}
\description{
\code{get_logrank_res} is a wrapper over the survival::survdiff() function
return the direct results or the log rank p-value only if specified.
}
\examples{
library("survival")
 
# Get survdiff results
fit <- survfit(Surv(time, status) ~ rx, data = colon)
get_logrank_res(formula(fit), colon)

# Get only log-rank p-value
get_logrank_res(formula(fit), colon, return.p = TRUE)
}

