% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epspath.R
\name{epspath}
\alias{epspath}
\title{Fit the entire \code{epsilon} path for Support Vector Regression}
\usage{
epspath(x, y, lambda = 1, kernel.function = radial.kernel,
  param.kernel = 1, ridge = 1e-08, eps = 1e-07, eps.min = 1e-08, ...)
}
\arguments{
\item{x}{The data matrix (n x p) with n rows (observations) on p variables (columns)}

\item{y}{The real number valued response variable}

\item{lambda}{The regularization parameter value.}

\item{kernel.function}{User defined kernel function. See \code{svmpath}.}

\item{param.kernel}{parameter(s) of the kernels. See \code{svmpath}.}

\item{ridge}{Sometimes the algorithm encounters singularities; in this case a small value of ridge can help, default is \code{ridge = 1e-8}}

\item{eps}{a small machine number which is used to identify minimal step sizes}

\item{eps.min}{The smallest value of epsilon for termination of the algorithm. Default is \code{eps.min = 1e-8}}

\item{...}{Generic compatibility}
}
\value{
a 'epspath' object is returned.
}
\description{
The Suport Vector Regression (SVR) employs epsilon-intensive loss which ignores errors smaller than epsilon. This algorithm computes the entire paths for SVR solution as a function of \code{epsilon} at a given regularization parameter \code{lambda}, which we call \code{epsilon} path.
}
\examples{
set.seed(1)
n <- 30
p <- 50

x <- matrix(rnorm(n*p), n, p)
e <- rnorm(n, 0, 1)
beta <- c(1, 1, rep(0, p-2))
y <- x \%*\% beta + e
lambda <- 1
obj <- epspath(x, y, lambda = lambda)
}
\seealso{
\code{\link{predict.epspath}}, \code{\link{plot.epspath}}, \code{\link{svrpath}}
}
\author{
Dohyun Kim, Seung Jun Shin
}
