% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airdas_check.R
\name{airdas_check}
\alias{airdas_check}
\title{Check AirDAS file}
\usage{
airdas_check(
  file,
  file.type = c("turtle", "caretta", "phocoena"),
  skip = 0,
  file.out = NULL,
  sp.codes = NULL,
  print.transect = TRUE
)
}
\arguments{
\item{file}{filename(s) of one or more AirDAS files}

\item{file.type}{character; indicates the program used to create \code{file}.
Must be one of: "turtle", "caretta", "survey", or "phocoena" (case
sensitive). Default is "turtle". Passed to \code{\link{airdas_read}}}

\item{skip}{integer: see \code{\link[readr]{read_fwf}}. Default is 0. Passed
to \code{\link{airdas_read}}}

\item{file.out}{character; filename to which to write the error log. Should
be a text or CSV file. Default is \code{NULL}}

\item{sp.codes}{character; filename of .dat file from which to read accepted
species codes. If \code{NULL}, default (internal) file will be used.
Default is \code{NULL}}

\item{print.transect}{logical; indicates if a table with all the transect
numbers in the \code{x} should be printed using \code{\link[base]{table}}.
Default is \code{TRUE}}
}
\value{
A data frame with five columns that list information about errors
found in the AirDAS files: the file name, line number, index (row number)
from the \code{airdas_read(file)} data frame, 'ID' (pre-Data# columns from
the DAS file), and description of the issue. This data frame is sorted by the
'Description' column. If there are multiple issues with the same line, the
issue descriptions are concatenated together using \code{paste(..., collapse
= "; ")}

If \code{print.transect} is \code{TRUE}, then the output of
\code{table(x$Data1[x$Event == "T"], useNA = "always")}, where \code{x} is
the output of \code{airdas_read(file, ...)} is printed

If \code{file.out} is not \code{NULL}, then the error log is also written to
the file (e.g., a .txt or .csv file) specified by \code{file.out}
}
\description{
Check that AirDAS file has accepted formatting and values
}
\details{
The default (internal) \code{sp.codes} file is located at
\code{system.file("SpCodesAirDAS.dat", package = "swfscAirDAS")}.

To see the checks performed by this function, you can access the PDF locally
at \code{system.file("AirDAS_check.pdf", package = "swfscAirDAS")}, or online
at
\url{https://github.com/swfsc/swfscAirDAS/blob/master/inst/AirDAS_check.pdf}

Checks that are not done by this function that may be of interest:
\itemize{
  \item Check for valid fish ball/mola/jelly/crab pot codes
  \item Check that datetimes are sequential, meaning they 
    1) are the same as or 2) come after the previous event
}
}
\examples{
y <- system.file("airdas_sample.das", package = "swfscAirDAS")
if (interactive()) airdas_check(y, print.transect = TRUE)

}
\seealso{
\url{https://swfsc.github.io/swfscAirDAS/}
}
