% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/odds.R
\name{odds}
\alias{invLogOdds}
\alias{invOdds}
\alias{logOdds}
\alias{odds}
\title{Odds Conversion}
\usage{
odds(x)

logOdds(x)

invOdds(x)

invLogOdds(x)
}
\arguments{
\item{x}{a numeric vector of probabilities (0 to 1), odds (0 to Inf), or log.odds (-Inf to Inf).}
}
\description{
\tabular{ll}{
  \code{odds} \tab converts probability to odds \cr
  \code{logOdds} \tab converts odds to log-odds \cr
  \code{invOdds} \tab converts odds to probability \cr
  \code{invLogOdds} \tab converts log-odds to odds \cr
}
}
\examples{
x <- sort(runif(10))
odds.df <- data.frame(x = x, odds = odds(x), logOdds = logOdds(x))
odds.df
invOdds(odds.df$odds)
invLogOdds(odds.df$logOdds)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

