% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swimplot.R
\name{swimmer_plot}
\alias{swimmer_plot}
\title{Creating the base of a swimmers plot}
\usage{
swimmer_plot(
  df,
  id = "id",
  end = "end",
  name_fill = NULL,
  name_col = NULL,
  id_order = "increasing",
  stratify = FALSE,
  base_size = 11,
  ...
)
}
\arguments{
\item{df}{a data frame}

\item{id}{column name for id, default is 'id'}

\item{end}{column name with the bar sizes (or bar end positions if bars change colour)}

\item{name_fill}{a column name to map the bar fill}

\item{name_col}{a column name to map the bar colour}

\item{id_order}{order of the bars by id, default is "increasing", can also input
"decreasing", a column name, or the ids in an order.}

\item{stratify}{a list of column names to stratify by}

\item{base_size}{the base size for the plot, default is 11}

\item{...}{additional geom_bar() arguments}
}
\value{
a swimmer plot with bars
}
\description{
This function allows you to create swimmers plots with bars, includes options to
have the bars change colours and create stratified plots
}
\examples{




swim_plot <-
swimmer_plot(df=ClinicalTrial.Arm,id='id',end='End_trt',name_fill='Arm',col="black",id_order='Arm')

# Add ggplot layers to improve the plot's aesthetic

swim_plot +
ggplot2::scale_fill_manual(name="Treatment",values=c("#e41a1c", "#377eb8","#4daf4a"))+
ggplot2::ylab('Time (Days)')



#Example with Stratification

swim_plot_stratify <- swimmer_plot(df=ClinicalTrial.Arm,id='id',end='End_trt',name_fill='Arm',
id_order ='increasing',col="black",alpha=0.75,width=.8,base_size = 18,stratify= c('Age','Sex'))

swim_plot_stratify +
ggplot2::scale_fill_manual(name="Treatment",values=c("#e41a1c", "#377eb8","#4daf4a"))+
ggplot2::ylab('Time (Days)')

}
\seealso{
\code{\link{swimmer_points}} \code{\link{swimmer_lines}}  \code{\link{swimmer_lines}}  \code{\link{swimmer_points_from_lines}} \code{\link{swimmer_arrows}}
}
