% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_results_stream.R
\name{get_swissvotes_stream}
\alias{get_swissvotes_stream}
\title{Get national results and counting status in real time}
\usage{
get_swissvotes_stream(votedate = NULL, geolevel = "municipality")
}
\arguments{
\item{votedate}{date of the ballot. Default: most recent ballot available. To select multiple ballots use the 'get_swissvotes'-function. Format = YYYYMMDD}

\item{geolevel}{geographical level for which the results should be loaded. options "national", "canton", "district" or "municipality"}
}
\value{
a tibble containing the results
}
\description{
\code{get_swissvote_stream} Allows to retrieve the results and the counting status for national ballots in realtime.
}
\details{
get_swissvote_stream - retrieve real time vote results for national ballots at district- or municipality level.
}
\examples{
 \donttest{
results <- get_swissvotes(votedate="20191002", geolevel = "district")

glimpse(results)


}

}
