% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{switchTo}
\alias{switchTo}
\alias{switchTo,character,character-method}
\alias{switchTo,character,character}
\alias{switchTo,character,SwitchrCtx-method}
\alias{switchTo,character,SwitchrCtx}
\alias{switchTo,character,missing-method}
\alias{switchTo,character,missing}
\alias{switchTo,SwitchrCtx,ANY-method}
\alias{switchTo,SwitchrCtx,ANY}
\alias{switchTo,character,RepoSubset-method}
\alias{switchTo,character,RepoSubset}
\alias{switchTo,character,PkgManifest-method}
\alias{switchTo,character,PkgManifest}
\alias{switchTo,character,SessionManifest-method}
\alias{switchTo,character,SessionManifest}
\title{switchTo}
\usage{
switchTo(
  name,
  seed = NULL,
  reverting = FALSE,
  ignoreRVersion = FALSE,
  exclude.site = TRUE,
  ...
)

\S4method{switchTo}{character,character}(
  name,
  seed = NULL,
  reverting = FALSE,
  ignoreRVersion = FALSE,
  exclude.site = TRUE,
  ...
)

\S4method{switchTo}{character,SwitchrCtx}(
  name,
  seed = NULL,
  reverting = FALSE,
  ignoreRVersion = FALSE,
  exclude.site = TRUE,
  ...
)

\S4method{switchTo}{character,missing}(
  name,
  seed = NULL,
  reverting = FALSE,
  ignoreRVersion = FALSE,
  exclude.site = TRUE,
  ...
)

\S4method{switchTo}{SwitchrCtx,ANY}(
  name,
  seed = NULL,
  reverting = FALSE,
  ignoreRVersion = FALSE,
  exclude.site = TRUE,
  ...
)

\S4method{switchTo}{character,RepoSubset}(
  name,
  seed = NULL,
  reverting = FALSE,
  ignoreRVersion = FALSE,
  exclude.site = TRUE,
  ...
)

\S4method{switchTo}{character,PkgManifest}(
  name,
  seed = NULL,
  reverting = FALSE,
  ignoreRVersion = FALSE,
  exclude.site = TRUE,
  ...
)

\S4method{switchTo}{character,SessionManifest}(
  name,
  seed = NULL,
  reverting = FALSE,
  ignoreRVersion = FALSE,
  exclude.site = TRUE,
  ...
)
}
\arguments{
\item{name}{The name associated (or to associate) with the computing
environment.}

\item{seed}{The seed, indicating packages to install into a newly created
package library
No effect if the library already exists}

\item{reverting}{Indicates whether we are reverting to the environment in
use before the current one. Typically not set directly by the user.}

\item{ignoreRVersion}{Should the R version in use be ignored when checking
for existing computing environmeSnts. This is experimental.}

\item{exclude.site}{Should the Site library be excluded when creating
and switching to the specified library. Defaults to \code{TRUE}}

\item{...}{Passed directly to \code{makeLibraryCtx} if an existing
computing environment is not found.}
}
\value{
Invisibly returns the SwitchrCtx object representing the new
computing environment
}
\description{
Switch to a different computing environment (set of installed R packages
and library location paths for new pkg installs)
}
\details{
If switchr does not now about the specified computing environment, a new one
will be created via installCompEnv. This includes
creating a directory under the switchr base directory and installing
packages into it. See \code{installCompEnv} for more details.

This function has the side effect of unloading all loaded
packages (other than base packages, GRAN or GRANBAse,  switchr itself, and
switchr's dependencies) and the associated DLLs. It also changes the library
location R will use to search for packages, e.g. when you call
\code{library}.

This means you will have to reinstall packages after switching, which is
important and intended (e.g. when switching to using Bioc devel from Bioc
release).
}
\note{
By default, this process involves a call to \code{flushSession} which will
attempt to unload all loaded packages. While some support of configuring
what is unloaded is provided via \code{switchrDontUnload}, it is recommended
that you turn this feature entirely off via \code{switchrNoUnload(TRUE)} when
using switchr within dyanmic documents (.Rnw/.Rmd files, etc), particularly
when using the knitr package.
}
\examples{
\dontrun{
switchTo("mynewlibrary")
switchBack()

fdman = GithubManifest("gmbecker/fastdigest")
switchTo("fastdigestlib", seed = fdman)
}
}
\references{
Becker G, Barr C, Gentleman R, Lawrence M; Enhancing Reproducibility and Collaboration via Management of R Package Cohorts. Journal of Statistical Software, 81(1). 2017. doi: 10.18637/jss.v082.i01
}
\seealso{
\code{\link{makeLibraryCtx}}
}
