% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sylcount.r
\name{sylcount}
\alias{sylcount}
\title{sylcount}
\usage{
sylcount(s, counts.only = TRUE)
}
\arguments{
\item{s}{A character vector (vector of strings).}

\item{counts.only}{Should only counts be returned, or words + counts?}
}
\value{
A list of dataframes.
}
\description{
A vectorized syllable counter for English language text.
}
\details{
The maximum supported word length is 64 characters. For any token having more
than 64 characters, the returned syllable count will be \code{NA}.

The syllable counter uses a hash table of known, mostly "irregular" (with
respect to syllable counting) words.  If the word is not known to us
(i.e., not in the hash table), then we try to "approximate" the number
of syllables by counting the number of non-consecutive vowels in a word.

So for example, using this scheme, each of "to", "too", and "tool" would be
classified as having one syllable.  However, "tune" would be classified as
having 2.  Fortunately, "tune" is in our table, listed as having 1 syllable.

The hash table uses a perfect hash generated by gperf.
}
\examples{
\dontrun{
library(sylcount)
a <- "I am the very model of a modern major general."
b <- "I have information vegetable, animal, and mineral."

sylcount(c(a, b))
sylcount(c(a, b), counts.only=FALSE)
}

}
\seealso{
\code{\link{readability}}
}
