% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impliedS.R
\name{impliedS}
\alias{impliedS}
\title{Compute a Symbolic Model-Implied Covariance/Correlation Matrix}
\usage{
impliedS(RAM, corr = FALSE, simplify = TRUE)
}
\arguments{
\item{RAM}{A RAM object including a list of matrices of the model returned
from \code{\link[metaSEM]{lavaan2RAM}}}

\item{corr}{Whether the model implied matrix is covariance (default) or
correlation structure.}

\item{simplify}{Attempt to simplify the output.}
}
\value{
The model implied covariance (or correlation) matrix and means vector.
}
\description{
It computes a symbolic model-implied covariance (or correlation) matrix in
SEM using the RAM inputs.
}
\examples{
\dontrun{

#### A mediation model
model1 <- "y ~ c*x + b*m
           m ~ a*x
           ## Means
           y ~ b0*1
           m ~ m0*1
           x ~ x0*1"

RAM1 <- metaSEM::lavaan2RAM(model1)

## Model-implied covariance matrix and mean structure
impliedS(RAM1, corr=FALSE)

## Model-implied correlation matrix
impliedS(RAM1, corr=TRUE)

#### A CFA model
model2 <- "f =~ x1 + x2 + x3 + x4#'
           ## Mean
           f ~ fmean*1"

RAM2 <- metaSEM::lavaan2RAM(model2)

## Model-implied covariance matrix
impliedS(RAM2, corr=FALSE)

## Model-implied correlation matrix
impliedS(RAM2, corr=TRUE)
}
}
\author{
Mike W.-L. Cheung <mikewlcheung@nus.edu.sg>
}
