% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\docType{methods}
\name{getCoefficient}
\alias{getCoefficient}
\alias{getCoefficient,symbolicQspray,numeric-method}
\title{Get a coefficient in a 'symbolicQspray' polynomial}
\usage{
\S4method{getCoefficient}{symbolicQspray,numeric}(qspray, exponents)
}
\arguments{
\item{qspray}{a \code{symbolicQspray} object}

\item{exponents}{a vector of exponents}
}
\value{
The coefficient as a \code{ratioOfQsprays} object.
}
\description{
Get the coefficient corresponding to the given sequence of
  exponents.
}
\examples{
library(qspray)
x <- qlone(1)
y <- qlone(2)
p <- 2*x^2 + 3*y - 5
getCoefficient(p, 2)       # coefficient of x^2
getCoefficient(p, c(2, 0)) # same as getCoefficient(p, 2)
getCoefficient(p, c(0, 1)) # coefficient of y (= x^0.y^1)
getCoefficient(p, 0)       # the constant term
getCoefficient(p, 3)       # coefficient of x^3
}
