% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ccs_by_triage.R
\name{get_ccs_by_triage}
\alias{get_ccs_by_triage}
\title{get_ccs_by_triage}
\usage{
get_ccs_by_triage(data, correct, vignettes, apps, triagelevel)
}
\arguments{
\item{data}{A dataframe}

\item{correct}{A string indicating the column name storing if the symptom checker solved the case (TRUE or FALSE)}

\item{vignettes}{A string indicating the column name storing the vignette or vignette number}

\item{apps}{A string indicating the column name storing the app names}

\item{triagelevel}{A string indicating the column name storing the correct triage solutions}
}
\value{
A data frame object containing the capability comparison score for each symptom checker on each triage level.
}
\description{
Calculates the Capability Comparison Score (CCS) for each symptom checker and each triage level
}
\examples{
data(symptomcheckRdata)
ccs <- get_ccs_by_triage(
  data = symptomcheckRdata,
  correct = "Correct_Triage_Advice_provided_from_app",
  vignettes = "Vignette_id",
  apps = "App_name",
  triagelevel = "Goldstandard_solution"
  )
}
