/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.Utilities;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class Validate {
    private Validate() {
    }

    public static Map<String, String> argsToMap(String[] stringArray, char c) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : stringArray) {
            String string2;
            String string3;
            int n = string.indexOf(c);
            if (n != -1) {
                if (n == string.length() - 1) {
                    string3 = "missing value in key-value pair: " + string;
                }
                string3 = string.substring(0, n);
                string2 = string.substring(n + 1);
                if (hashMap.containsKey(string3)) {
                    String string4 = "duplicate arguments: " + string3;
                    throw new IllegalArgumentException(string4);
                }
            } else {
                string3 = "unrecognized argument: " + string;
                throw new IllegalArgumentException(string3);
            }
            hashMap.put(string3, string2);
        }
        return hashMap;
    }

    public static void confirmEmptyMap(Map<String, String> map) {
        Set<String> set = map.keySet();
        if (!set.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(50);
            stringBuilder.append("Error: unrecognized parameter");
            stringBuilder.append(set.size() == 1 ? ":" : "s:");
            for (String string : set) {
                String string2 = map.get(string);
                stringBuilder.append(' ');
                stringBuilder.append(string);
                stringBuilder.append('=');
                stringBuilder.append(string2);
            }
            Utilities.exit(stringBuilder.toString());
        }
    }

    public static File getFile(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("filename.isEmpty()==true");
        }
        File file = new File(string);
        if (!file.exists()) {
            String string2 = "File does not exist: " + file;
            throw new IllegalArgumentException(string2);
        }
        if (file.isDirectory()) {
            String string3 = "File is a directory: " + file;
            throw new IllegalArgumentException(string3);
        }
        return file;
    }

    public static int intArg(String string, Map<String, String> map, boolean bl, int n, int n2, int n3) {
        Validate.checkIntValue(string, n, n2, n3);
        String string2 = map.remove(string);
        if (string2 == null) {
            if (bl) {
                String string3 = "missing " + string + " argument";
                throw new IllegalArgumentException(string3);
            }
            return n;
        }
        return Validate.parseInt(string, string2, n2, n3);
    }

    public static long longArg(String string, Map<String, String> map, boolean bl, long l, long l2, long l3) {
        Validate.checkLongValue(string, l, l2, l3);
        String string2 = map.remove(string);
        if (string2 == null) {
            if (bl) {
                String string3 = "missing " + string + " argument";
                throw new IllegalArgumentException(string3);
            }
            return l;
        }
        return Validate.parseLong(string, string2, l2, l3);
    }

    public static float floatArg(String string, Map<String, String> map, boolean bl, float f, float f2, float f3) {
        Validate.checkFloatValue(string, f, f2, f3);
        String string2 = map.remove(string);
        if (string2 == null) {
            if (bl) {
                String string3 = "missing " + string + " argument";
                throw new IllegalArgumentException(string3);
            }
            return f;
        }
        return Validate.parseFloat(string, string2, f2, f3);
    }

    public static double doubleArg(String string, Map<String, String> map, boolean bl, double d, double d2, double d3) {
        Validate.checkDoubleValue(string, d, d2, d3);
        String string2 = map.remove(string);
        if (string2 == null) {
            if (bl) {
                String string3 = "missing " + string + " argument";
                throw new IllegalArgumentException(string3);
            }
            return d;
        }
        return Validate.parseDouble(string, string2, d2, d3);
    }

    public static boolean booleanArg(String string, Map<String, String> map, boolean bl, boolean bl2) {
        String string2 = map.remove(string);
        if (string2 == null) {
            if (bl) {
                String string3 = "missing " + string + " argument";
                throw new IllegalArgumentException(string3);
            }
            return bl2;
        }
        return Validate.parseBoolean(string2);
    }

    public static String stringArg(String string, Map<String, String> map, boolean bl, String string2, String[] stringArray) {
        Validate.checkStringValue(string, string2, stringArray);
        String string3 = map.remove(string);
        if (string3 == null) {
            if (bl) {
                String string4 = "missing " + string + " argument";
                throw new IllegalArgumentException(string4);
            }
            return string2;
        }
        Validate.checkStringValue(string, string3, stringArray);
        return string3;
    }

    private static int parseInt(String string, String string2, int n, int n2) {
        try {
            int n3 = Integer.parseInt(string2);
            Validate.checkIntValue(string, n3, n, n2);
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string2 + " is not a number");
        }
    }

    private static long parseLong(String string, String string2, long l, long l2) {
        try {
            long l3 = Long.parseLong(string2);
            Validate.checkLongValue(string, l3, l, l2);
            return l3;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string2 + " is not a number");
        }
    }

    private static float parseFloat(String string, String string2, float f, float f2) {
        try {
            float f3 = Float.parseFloat(string2);
            Validate.checkFloatValue(string, f3, f, f2);
            return f3;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string2 + " is not a number");
        }
    }

    private static double parseDouble(String string, String string2, double d, double d2) {
        try {
            double d3 = Double.parseDouble(string2);
            Validate.checkDoubleValue(string, d3, d, d2);
            return d3;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string2 + " is not a number");
        }
    }

    private static boolean parseBoolean(String string) {
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t")) {
            return true;
        }
        if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("f")) {
            return false;
        }
        String string2 = string + " is not \"true\" or \"false\"";
        throw new IllegalArgumentException(string2);
    }

    private static void checkIntValue(String string, int n, int n2, int n3) {
        String string2 = null;
        if (n2 > n3) {
            string2 = "min=" + n2 + " > max=" + n3;
        } else if (n < n2) {
            string2 = "value=" + n + " < " + n2;
        } else if (n > n3) {
            string2 = "value=" + n + " > " + n3;
        }
        if (string2 != null) {
            String string3 = "Error in \"" + string + "\" argument: ";
            throw new IllegalArgumentException(string3 + string2);
        }
    }

    private static void checkLongValue(String string, long l, long l2, long l3) {
        String string2 = null;
        if (l2 > l3) {
            string2 = "min=" + l2 + " > max=" + l3;
        } else if (l < l2) {
            string2 = "value=" + l + " < " + l2;
        } else if (l > l3) {
            string2 = "value=" + l + " > " + l3;
        }
        if (string2 != null) {
            String string3 = "Error in \"" + string + "\" argument: ";
            throw new IllegalArgumentException(string3 + string2);
        }
    }

    private static void checkFloatValue(String string, float f, float f2, float f3) {
        String string2 = null;
        if (Float.isNaN(f)) {
            string2 = "value=" + f;
        } else if (f2 > f3) {
            string2 = "min=" + f2 + " > max=" + f3;
        } else if (f < f2) {
            string2 = "value=" + f + " < " + f2;
        } else if (f > f3) {
            string2 = "value=" + f + " > " + f3;
        }
        if (string2 != null) {
            String string3 = "Error in \"" + string + "\" argument: ";
            throw new IllegalArgumentException(string3 + string2);
        }
    }

    private static void checkDoubleValue(String string, double d, double d2, double d3) {
        String string2 = null;
        if (Double.isNaN(d)) {
            string2 = "value=" + d;
        } else if (d2 > d3) {
            string2 = "min=" + d2 + " > max=" + d3;
        } else if (d < d2) {
            string2 = "value=" + d + " < " + d2;
        } else if (d > d3) {
            string2 = "value=" + d + " > " + d3;
        }
        if (string2 != null) {
            String string3 = "Error in \"" + string + "\" argument: ";
            throw new IllegalArgumentException(string3 + string2);
        }
    }

    private static void checkStringValue(String string, String string2, String[] stringArray) {
        if (stringArray != null) {
            boolean bl = false;
            for (int i = 0; i < stringArray.length && !bl; ++i) {
                String string3 = stringArray[i];
                bl = string3 == null ? string2 == null : string3.equals(string2);
            }
            if (!bl) {
                String string4 = "Error in \"" + string + "\" argument: \"" + string2 + "\" is not in " + Arrays.toString(stringArray);
                throw new IllegalArgumentException(string4);
            }
        }
    }
}

