/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import beagleutil.Samples;
import haplotype.HapPair;
import haplotype.SampleHapPairs;
import java.util.Comparator;
import java.util.List;
import vcf.Marker;
import vcf.Markers;

public final class BasicSampleHapPairs
implements SampleHapPairs {
    private final Samples samples;
    private final Markers markers;
    private final HapPair[] hapPairs;
    private final boolean reverseMarkers;
    private final int lastMarker;

    public BasicSampleHapPairs(Samples samples, List<HapPair> list) {
        this(samples, list, false);
    }

    public BasicSampleHapPairs(Samples samples, List<HapPair> list, boolean bl) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("haps.isEmpy()==true");
        }
        this.checkSamples(samples, list);
        Markers markers = BasicSampleHapPairs.checkAndExtractMarkers(list);
        this.samples = samples;
        this.markers = bl ? markers.reverse() : markers;
        this.hapPairs = list.toArray(new HapPair[0]);
        this.reverseMarkers = bl;
        this.lastMarker = this.markers.nMarkers() - 1;
    }

    private void checkSamples(Samples samples, List<HapPair> list) {
        if (samples.nSamples() != list.size()) {
            String string = "samples and hapPairList are inconsistent";
            throw new IllegalArgumentException(string);
        }
        int n = samples.nSamples();
        for (int i = 0; i < n; ++i) {
            if (samples.idIndex(i) == list.get(i).idIndex()) continue;
            String string = "samples and hapPairList are inconsistent";
            throw new IllegalArgumentException(string);
        }
    }

    public static Markers checkAndExtractMarkers(List<HapPair> list) {
        if (list.isEmpty()) {
            return new Markers(new Marker[0]);
        }
        Markers markers = list.get(0).markers();
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            if (list.get(i).markers().equals(markers)) continue;
            String string = "Markers are not consistent";
            throw new IllegalArgumentException(string);
        }
        return markers;
    }

    @Override
    public byte allele1(int n, int n2) {
        if (this.reverseMarkers) {
            n = this.lastMarker - n;
        }
        return this.hapPairs[n2].allele1(n);
    }

    @Override
    public byte allele2(int n, int n2) {
        if (this.reverseMarkers) {
            n = this.lastMarker - n;
        }
        return this.hapPairs[n2].allele2(n);
    }

    @Override
    public byte allele(int n, int n2) {
        if (this.reverseMarkers) {
            n = this.lastMarker - n;
        }
        int n3 = n2 / 2;
        if ((n2 & 1) == 0) {
            return this.hapPairs[n3].allele1(n);
        }
        return this.hapPairs[n3].allele2(n);
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public int nHaps() {
        return 2 * this.hapPairs.length;
    }

    @Override
    public int nHapPairs() {
        return this.hapPairs.length;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int idIndex(int n) {
        return this.hapPairs[n].idIndex();
    }

    public static Comparator<HapPair> hapsComparator() {
        return new Comparator<HapPair>(){

            @Override
            public int compare(HapPair hapPair, HapPair hapPair2) {
                int n;
                int n2 = hapPair.idIndex();
                if (n2 == (n = hapPair2.idIndex())) {
                    return 0;
                }
                return n2 < n ? -1 : 1;
            }
        };
    }

    public static Comparator<HapPair> hapsComparator(final Samples samples) {
        if (samples == null) {
            throw new NullPointerException("samples==null");
        }
        return new Comparator<HapPair>(){

            @Override
            public int compare(HapPair hapPair, HapPair hapPair2) {
                int n;
                int n2 = samples.index(hapPair.idIndex());
                if (n2 == (n = samples.index(hapPair2.idIndex()))) {
                    return 0;
                }
                return n2 < n ? -1 : 1;
            }
        };
    }
}

