/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import main.GenotypeValues;
import vcf.Marker;
import vcf.Markers;

public final class RestrictedGenotypeValues
implements GenotypeValues {
    private final GenotypeValues gv;
    private final Markers restriction;
    private final int[] inclusionMap;

    public RestrictedGenotypeValues(GenotypeValues genotypeValues, Markers markers) {
        this.gv = genotypeValues;
        this.restriction = markers;
        int[] nArray = new int[markers.nMarkers()];
        int n = 0;
        int n2 = genotypeValues.nMarkers();
        for (int i = 0; i < n2; ++i) {
            if (n >= nArray.length || !genotypeValues.marker(i).equals(markers.marker(n))) continue;
            nArray[n++] = i;
        }
        if (n != nArray.length) {
            throw new IllegalArgumentException("invalid restricted markers");
        }
        this.inclusionMap = nArray;
    }

    @Override
    public float value(int n, int n2, int n3) {
        return this.gv.value(this.inclusionMap[n], n2, n3);
    }

    @Override
    public void add(int n, double[] dArray) {
        if (dArray.length != this.restriction.sumGenotypes()) {
            throw new IllegalArgumentException("values.length=" + dArray.length);
        }
        int n2 = 0;
        for (int i = 0; i < this.inclusionMap.length; ++i) {
            int n3 = this.restriction.marker(i).nGenotypes();
            for (int j = 0; j < n3; ++j) {
                this.gv.add(this.inclusionMap[i], n, j, dArray[n2++]);
            }
        }
        assert (n2 == dArray.length);
    }

    @Override
    public void add(int n, int n2, int n3, double d) {
        this.gv.add(this.inclusionMap[n], n2, n3, d);
    }

    @Override
    public Samples samples() {
        return this.gv.samples();
    }

    @Override
    public int nSamples() {
        return this.gv.samples().nSamples();
    }

    @Override
    public Marker marker(int n) {
        return this.restriction.marker(n);
    }

    @Override
    public Markers markers() {
        return this.restriction;
    }

    @Override
    public int nMarkers() {
        return this.restriction.nMarkers();
    }
}

