/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import java.util.BitSet;
import main.Logger;
import main.NuclearFamilies;
import vcf.Marker;
import vcf.VcfEmission;
import vcf.VcfRecord;

public final class BitSetGT
implements VcfEmission {
    public static final String GT_FORMAT = "GT";
    private final byte bitsPerAllele;
    private final Samples samples;
    private final Marker marker;
    private final boolean isRefData;
    private final BitSet allele1;
    private final BitSet allele2;
    private final BitSet isMissing1;
    private final BitSet isMissing2;
    private final BitSet isPhased;

    public BitSetGT(VcfRecord vcfRecord, boolean bl) {
        this(vcfRecord);
        BitSetGT.setBits(vcfRecord, bl, this.bitsPerAllele, this.allele1, this.allele2, this.isMissing1, this.isMissing2, this.isPhased);
    }

    public BitSetGT(VcfRecord vcfRecord, NuclearFamilies nuclearFamilies, boolean bl) {
        this(vcfRecord);
        if (!vcfRecord.samples().equals(nuclearFamilies.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        BitSetGT.setBits(vcfRecord, bl, this.bitsPerAllele, this.allele1, this.allele2, this.isMissing1, this.isMissing2, this.isPhased);
        BitSetGT.removeMendelianInconsistencies(vcfRecord, nuclearFamilies, this.isPhased, this.isMissing1, this.isMissing2);
    }

    private BitSetGT(VcfRecord vcfRecord) {
        int n = vcfRecord.nSamples();
        if (n == 0) {
            String string = "missing sample data: " + vcfRecord;
            throw new IllegalArgumentException(string);
        }
        if (!vcfRecord.hasFormat(GT_FORMAT)) {
            String string = "missing GT FORMAT: " + vcfRecord;
            throw new IllegalArgumentException(string);
        }
        this.bitsPerAllele = BitSetGT.bitsPerAllele(vcfRecord.marker());
        this.samples = vcfRecord.samples();
        this.marker = vcfRecord.marker();
        this.isRefData = BitSetGT.isRef(vcfRecord);
        this.allele1 = new BitSet(n * this.bitsPerAllele);
        this.allele2 = new BitSet(n * this.bitsPerAllele);
        this.isMissing1 = new BitSet(n);
        this.isMissing2 = new BitSet(n);
        this.isPhased = new BitSet(n);
    }

    private static boolean isRef(VcfRecord vcfRecord) {
        int n = vcfRecord.nSamples();
        for (int i = 0; i < n; ++i) {
            if (vcfRecord.isPhased(i) && vcfRecord.gt(i, 0) >= 0 && vcfRecord.gt(i, 1) >= 0) continue;
            return false;
        }
        return true;
    }

    private static void setBits(VcfRecord vcfRecord, boolean bl, int n, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4, BitSet bitSet5) {
        int n2 = 0;
        int n3 = 0;
        int n4 = vcfRecord.nSamples();
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6;
            if (bl && vcfRecord.isPhased(i)) {
                bitSet5.set(i);
            }
            byte by = vcfRecord.gt(i, 0);
            byte by2 = vcfRecord.gt(i, 1);
            if (by < 0) {
                bitSet3.set(i);
                n2 += n;
            } else {
                n6 = 1;
                for (n5 = 0; n5 < n; ++n5) {
                    if ((by & n6) == n6) {
                        bitSet.set(n2);
                    }
                    ++n2;
                    n6 <<= 1;
                }
            }
            if (by2 < 0) {
                bitSet4.set(i);
                n3 += n;
                continue;
            }
            n6 = 1;
            for (n5 = 0; n5 < n; ++n5) {
                if ((by2 & n6) == n6) {
                    bitSet2.set(n3);
                }
                ++n3;
                n6 <<= 1;
            }
        }
    }

    private static byte bitsPerAllele(Marker marker) {
        int n = marker.nAlleles() - 1;
        int n2 = 32 - Integer.numberOfLeadingZeros(n);
        return (byte)n2;
    }

    private static void removeMendelianInconsistencies(VcfRecord vcfRecord, NuclearFamilies nuclearFamilies, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        int n;
        int n2;
        int n3;
        int n4 = nuclearFamilies.nDuos();
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = nuclearFamilies.duoParent(n3);
            n = nuclearFamilies.duoOffspring(n3);
            bitSet.clear(n2);
            bitSet.clear(n);
            if (BitSetGT.duoIsConsistent(vcfRecord, n2, n)) continue;
            BitSetGT.logDuoInconsistency(vcfRecord, n2, n);
            bitSet2.set(n2);
            bitSet3.set(n2);
            bitSet2.set(n);
            bitSet3.set(n);
        }
        n4 = nuclearFamilies.nTrios();
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = nuclearFamilies.trioFather(n3);
            n = nuclearFamilies.trioMother(n3);
            int n5 = nuclearFamilies.trioOffspring(n3);
            bitSet.clear(n2);
            bitSet.clear(n);
            bitSet.clear(n5);
            if (BitSetGT.trioIsConsistent(vcfRecord, n2, n, n5)) continue;
            BitSetGT.logTrioInconsistency(vcfRecord, n2, n, n5);
            bitSet2.set(n2);
            bitSet3.set(n2);
            bitSet2.set(n);
            bitSet3.set(n);
            bitSet2.set(n5);
            bitSet3.set(n5);
        }
    }

    private static boolean duoIsConsistent(VcfRecord vcfRecord, int n, int n2) {
        byte by = vcfRecord.gt(n, 0);
        byte by2 = vcfRecord.gt(n, 1);
        byte by3 = vcfRecord.gt(n2, 0);
        byte by4 = vcfRecord.gt(n2, 1);
        boolean bl = by < 0 || by2 < 0 || by3 < 0 || by4 < 0;
        return bl || by == by3 || by == by4 || by2 == by3 || by2 == by4;
    }

    private static boolean trioIsConsistent(VcfRecord vcfRecord, int n, int n2, int n3) {
        boolean bl;
        byte by = vcfRecord.gt(n, 0);
        byte by2 = vcfRecord.gt(n, 1);
        byte by3 = vcfRecord.gt(n2, 0);
        byte by4 = vcfRecord.gt(n2, 1);
        byte by5 = vcfRecord.gt(n3, 0);
        byte by6 = vcfRecord.gt(n3, 1);
        boolean bl2 = by5 < 0 || by < 0 || by2 < 0 || by5 == by || by5 == by2;
        boolean bl3 = bl = by6 < 0 || by3 < 0 || by4 < 0 || by6 == by3 || by6 == by4;
        if (bl2 && bl) {
            return true;
        }
        boolean bl4 = by6 < 0 || by < 0 || by2 < 0 || by6 == by || by6 == by2;
        boolean bl5 = by5 < 0 || by3 < 0 || by4 < 0 || by5 == by3 || by5 == by4;
        return bl4 && bl5;
    }

    private static void logDuoInconsistency(VcfRecord vcfRecord, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("WARNING: Inconsistent duo genotype set to missing");
        stringBuilder.append('\t');
        stringBuilder.append(vcfRecord.marker());
        stringBuilder.append(':');
        stringBuilder.append(vcfRecord.samples().id(n));
        stringBuilder.append('\t');
        stringBuilder.append(vcfRecord.samples().id(n2));
        Logger.getInstance().println(stringBuilder.toString());
    }

    private static void logTrioInconsistency(VcfRecord vcfRecord, int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("WARNING: Inconsistent trio genotype set to missing");
        stringBuilder.append('\t');
        stringBuilder.append(vcfRecord.marker());
        stringBuilder.append('\t');
        stringBuilder.append(vcfRecord.samples().id(n));
        stringBuilder.append('\t');
        stringBuilder.append(vcfRecord.samples().id(n2));
        stringBuilder.append('\t');
        stringBuilder.append(vcfRecord.samples().id(n3));
        Logger.getInstance().println(stringBuilder.toString());
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isRefData() {
        return this.isRefData;
    }

    @Override
    public boolean isMissingData() {
        int n = this.isMissing1.cardinality() + this.isMissing2.cardinality();
        return n == 2 * this.samples.nSamples();
    }

    @Override
    public boolean isPhased(int n) {
        return this.isPhased.get(n);
    }

    @Override
    public byte allele1(int n) {
        return this.isMissing1.get(n) ? (byte)-1 : this.allele(this.allele1, n);
    }

    @Override
    public byte allele2(int n) {
        return this.isMissing2.get(n) ? (byte)-1 : this.allele(this.allele2, n);
    }

    @Override
    public float gl(int n, byte by, byte by2) {
        if (by < 0 || by >= this.marker.nAlleles()) {
            String string = "invalid alleles: (" + by + "): " + this.marker;
            throw new IllegalArgumentException(string);
        }
        if (by2 < 0 || by2 >= this.marker.nAlleles()) {
            String string = "invalid alleles: (" + by2 + "): " + this.marker;
            throw new IllegalArgumentException(string);
        }
        if (this.isMissing1.get(n) && this.isMissing2.get(n)) {
            return 1.0f;
        }
        if (this.isMissing1.get(n) ^ this.isMissing2.get(n)) {
            boolean bl;
            byte by3 = this.allele1(n);
            byte by4 = this.allele2(n);
            boolean bl2 = bl = !(by3 >= 0 && by3 != by || by4 >= 0 && by4 != by2);
            if (!this.isPhased.get(n) && !bl) {
                bl = !(by3 >= 0 && by3 != by2 || by4 >= 0 && by4 != by);
            }
            return bl ? 1.0f : 0.0f;
        }
        byte by5 = this.allele(this.allele1, n);
        byte by6 = this.allele(this.allele2, n);
        if (this.isPhased.get(n)) {
            return by5 == by && by6 == by2 ? 1.0f : 0.0f;
        }
        boolean bl = by5 == by && by6 == by2 || by5 == by2 && by6 == by;
        return bl ? 1.0f : 0.0f;
    }

    private byte allele(BitSet bitSet, int n) {
        int n2 = this.bitsPerAllele * n;
        int n3 = n2 + this.bitsPerAllele;
        byte by = 0;
        byte by2 = 1;
        for (int i = n2; i < n3; ++i) {
            if (bitSet.get(i)) {
                by = (byte)(by + by2);
            }
            by2 = (byte)(by2 << 1);
        }
        return by;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.marker);
        stringBuilder.append('\t');
        stringBuilder.append('.');
        stringBuilder.append('\t');
        stringBuilder.append("PASS");
        stringBuilder.append('\t');
        stringBuilder.append('.');
        stringBuilder.append('\t');
        stringBuilder.append(GT_FORMAT);
        int n = this.samples.nSamples();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('\t');
            stringBuilder.append(this.isMissing1.get(i) ? 46 : (int)this.allele(this.allele1, i));
            stringBuilder.append(this.isPhased.get(i) ? (char)'|' : '/');
            stringBuilder.append(this.isMissing2.get(i) ? 46 : (int)this.allele(this.allele2, i));
        }
        return stringBuilder.toString();
    }
}

