/*
 * Decompiled with CFR 0.152.
 */
package sample;

import dag.Dag;
import haplotype.BitHapPair;
import haplotype.HapPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import sample.DuoBaumLevel;
import sample.DuoNodes;
import vcf.GL;

public class DuoBaum {
    private final Dag dag;
    private final GL gl;
    private final int nMarkers;
    private final int nCopies;
    private final long seed;
    private final Random random;
    private final int[] nodeAB1;
    private final int[] nodeA2;
    private final int[] nodeB2;
    private final double[] nodeValue;
    private final byte[][] allelesAB1;
    private final byte[][] allelesA2;
    private final byte[][] allelesB2;
    private final DuoBaumLevel[] levels;
    private final DuoNodes fwdNodes;
    private final DuoNodes bwdNodes;
    private int windowIndex = -9999;
    private int arrayIndex = -9999;

    public DuoBaum(Dag dag, GL gL, long l, int n) {
        if (!dag.markers().equals(gL.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (n < 1) {
            throw new IllegalArgumentException("nCopies<1: " + n);
        }
        this.dag = dag;
        this.gl = gL;
        this.nMarkers = dag.nMarkers();
        this.nCopies = n;
        this.seed = l;
        this.random = new Random(l);
        this.nodeAB1 = new int[n];
        this.nodeA2 = new int[n];
        this.nodeB2 = new int[n];
        this.nodeValue = new double[n];
        this.allelesAB1 = new byte[n][gL.nMarkers()];
        this.allelesA2 = new byte[n][gL.nMarkers()];
        this.allelesB2 = new byte[n][gL.nMarkers()];
        int n2 = (int)Math.ceil(Math.sqrt(1 + 8 * dag.nMarkers()) / 2.0) + 1;
        this.levels = new DuoBaumLevel[n2];
        for (int i = 0; i < this.levels.length; ++i) {
            this.levels[i] = new DuoBaumLevel(dag, gL);
        }
        this.fwdNodes = new DuoNodes();
        this.bwdNodes = new DuoNodes();
    }

    public Dag dag() {
        return this.dag;
    }

    public GL gl() {
        return this.gl;
    }

    public int nCopies() {
        return this.nCopies;
    }

    public long seed() {
        return this.seed;
    }

    public List<HapPair> sample(int n, int n2) {
        this.forwardAlgorithm(n, n2);
        this.initSampleAlleles(this.currentLevel(), n, n2);
        for (int i = this.nMarkers - 2; i >= 0; --i) {
            DuoBaumLevel duoBaumLevel = this.previousLevel(n, n2);
            this.sampleAlleles(duoBaumLevel, n, n2);
        }
        return this.hapList(n, n2);
    }

    public List<HapPair> sample(int n, int n2, double[] dArray, double[] dArray2) {
        this.checkGprobs(dArray, dArray2);
        this.forwardAlgorithm(n, n2);
        this.initSampleAlleles(this.currentLevel(), n, n2);
        this.currentLevel().setInitialBackwardValues(this.bwdNodes);
        this.setGprobs(this.currentLevel(), dArray, dArray2);
        for (int i = this.nMarkers - 2; i >= 0; --i) {
            DuoBaumLevel duoBaumLevel = this.previousLevel(n, n2);
            this.sampleAlleles(duoBaumLevel, n, n2);
            duoBaumLevel.setBackwardValues(this.bwdNodes);
            this.setGprobs(duoBaumLevel, dArray, dArray2);
        }
        return this.hapList(n, n2);
    }

    private void checkGprobs(double[] dArray, double[] dArray2) {
        int n = this.gl.markers().sumGenotypes();
        if (dArray.length != n || dArray2.length != n) {
            String string = "gtProbs.length!=gl.markers().sumGenotypes()";
            throw new IllegalArgumentException(string);
        }
    }

    private void setGprobs(DuoBaumLevel duoBaumLevel, double[] dArray, double[] dArray2) {
        int n = duoBaumLevel.marker();
        int n2 = this.gl.marker(n).nGenotypes();
        int n3 = this.gl.markers().sumGenotypes(n);
        for (int i = 0; i < n2; ++i) {
            dArray[n3 + i] = duoBaumLevel.gtProbsA(i);
            dArray2[n3 + i] = duoBaumLevel.gtProbsB(i);
        }
    }

    private List<HapPair> hapList(int n, int n2) {
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>(2 * this.nCopies);
        for (int i = 0; i < this.nCopies; ++i) {
            BitHapPair bitHapPair = new BitHapPair(this.gl.markers(), this.gl.samples().idIndex(n), this.allelesAB1[i], this.allelesA2[i]);
            BitHapPair bitHapPair2 = new BitHapPair(this.gl.markers(), this.gl.samples().idIndex(n2), this.allelesAB1[i], this.allelesB2[i]);
            arrayList.add(bitHapPair);
            arrayList.add(bitHapPair2);
        }
        return arrayList;
    }

    private void initSampleAlleles(DuoBaumLevel duoBaumLevel, int n, int n2) {
        int n3 = duoBaumLevel.marker();
        for (int i = 0; i < this.nCopies; ++i) {
            int n4 = this.initialRandomState(duoBaumLevel);
            this.nodeAB1[i] = duoBaumLevel.parentNodeAB1(n4);
            this.nodeA2[i] = duoBaumLevel.parentNodeA2(n4);
            this.nodeB2[i] = duoBaumLevel.parentNodeB2(n4);
            this.nodeValue[i] = this.parentSum(duoBaumLevel, n, n2, n4);
            this.allelesAB1[i][n3] = duoBaumLevel.symbolAB1(n4);
            this.allelesA2[i][n3] = duoBaumLevel.symbolA2(n4);
            this.allelesB2[i][n3] = duoBaumLevel.symbolB2(n4);
        }
    }

    private int initialRandomState(DuoBaumLevel duoBaumLevel) {
        double d = this.random.nextDouble();
        double d2 = 0.0;
        int n = duoBaumLevel.size();
        for (int i = 0; i < n; ++i) {
            if (!(d <= (d2 += duoBaumLevel.forwardValue(i)))) continue;
            return i;
        }
        assert (false);
        return duoBaumLevel.size() - 1;
    }

    private double parentSum(DuoBaumLevel duoBaumLevel, int n, int n2, int n3) {
        int n4 = duoBaumLevel.marker();
        double d = duoBaumLevel.forwardValuesSum() * duoBaumLevel.forwardValue(n3);
        int n5 = duoBaumLevel.edgeAB1(n3);
        int n6 = duoBaumLevel.edgeA2(n3);
        int n7 = duoBaumLevel.edgeB2(n3);
        double d2 = this.dag.condEdgeProb(n4, n5);
        double d3 = this.dag.condEdgeProb(n4, n6);
        double d4 = this.dag.condEdgeProb(n4, n7);
        byte by = this.dag.symbol(n4, n5);
        byte by2 = this.dag.symbol(n4, n6);
        byte by3 = this.dag.symbol(n4, n7);
        double d5 = this.gl.gl(n4, n, by, by2);
        double d6 = this.gl.gl(n4, n2, by, by3);
        return d / (d5 * d6 * (d2 * d3 * d4));
    }

    private void sampleAlleles(DuoBaumLevel duoBaumLevel, int n, int n2) {
        int n3 = duoBaumLevel.marker();
        for (int i = 0; i < this.nCopies; ++i) {
            int n4 = this.randomPreviousState(duoBaumLevel, this.nodeAB1[i], this.nodeA2[i], this.nodeB2[i], this.nodeValue[i]);
            this.nodeAB1[i] = duoBaumLevel.parentNodeAB1(n4);
            this.nodeA2[i] = duoBaumLevel.parentNodeA2(n4);
            this.nodeB2[i] = duoBaumLevel.parentNodeB2(n4);
            this.nodeValue[i] = this.parentSum(duoBaumLevel, n, n2, n4);
            this.allelesAB1[i][n3] = duoBaumLevel.symbolAB1(n4);
            this.allelesA2[i][n3] = duoBaumLevel.symbolA2(n4);
            this.allelesB2[i][n3] = duoBaumLevel.symbolB2(n4);
        }
    }

    private int randomPreviousState(DuoBaumLevel duoBaumLevel, int n, int n2, int n3, double d) {
        double d2 = this.random.nextDouble() * d;
        double d3 = 0.0;
        int n4 = duoBaumLevel.size();
        for (int i = 0; i < n4; ++i) {
            if (n != duoBaumLevel.childNodeAB1(i) || n2 != duoBaumLevel.childNodeA2(i) || n3 != duoBaumLevel.childNodeB2(i) || !(d2 <= (d3 += duoBaumLevel.forwardValue(i)))) continue;
            return i;
        }
        return duoBaumLevel.size() - 1;
    }

    private DuoBaumLevel nextLevel() {
        ++this.arrayIndex;
        if (this.arrayIndex == this.levels.length) {
            ++this.windowIndex;
            this.arrayIndex = this.windowIndex;
        }
        return this.levels[this.arrayIndex];
    }

    private DuoBaumLevel currentLevel() {
        return this.levels[this.arrayIndex];
    }

    private DuoBaumLevel previousLevel(int n, int n2) {
        if (this.arrayIndex == this.windowIndex) {
            --this.windowIndex;
            this.arrayIndex = this.windowIndex;
            this.levels[this.arrayIndex].setChildNodes(this.fwdNodes);
            int n3 = this.levels[this.windowIndex].marker() + 1;
            int n4 = n3 + (this.levels.length - (this.windowIndex + 1));
            for (int i = n3; i < n4; ++i) {
                this.nextLevel().setForwardValues(this.fwdNodes, i, n, n2);
            }
            return this.currentLevel();
        }
        return this.levels[--this.arrayIndex];
    }

    private void forwardAlgorithm(int n, int n2) {
        DuoBaumLevel.initializeNodes(this.fwdNodes);
        this.windowIndex = -1;
        this.arrayIndex = this.levels.length - 1;
        for (int i = 0; i < this.nMarkers; ++i) {
            this.nextLevel().setForwardValues(this.fwdNodes, i, n, n2);
        }
    }
}

