/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import net.sf.samtools.FileTruncatedException;
import net.sf.samtools.util.BlockCompressedFilePointerUtil;
import net.sf.samtools.util.BlockCompressedStreamConstants;
import net.sf.samtools.util.BlockGunzipper;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.SeekableBufferedStream;
import net.sf.samtools.util.SeekableFileStream;
import net.sf.samtools.util.SeekableHTTPStream;
import net.sf.samtools.util.SeekableStream;

public class BlockCompressedInputStream
extends InputStream {
    private InputStream mStream = null;
    private SeekableStream mFile = null;
    private byte[] mFileBuffer = null;
    private byte[] mCurrentBlock = null;
    private int mCurrentOffset = 0;
    private long mBlockAddress = 0L;
    private int mLastBlockLength = 0;
    private final BlockGunzipper blockGunzipper = new BlockGunzipper();
    private volatile ByteArrayOutputStream buf = null;
    private static final byte eol = 10;
    private static final byte eolCr = 13;

    public BlockCompressedInputStream(InputStream inputStream) {
        this.mStream = IOUtil.toBufferedStream(inputStream);
        this.mFile = null;
    }

    public BlockCompressedInputStream(File file) throws IOException {
        this.mFile = new SeekableFileStream(file);
        this.mStream = null;
    }

    public BlockCompressedInputStream(URL uRL) {
        this.mFile = new SeekableBufferedStream(new SeekableHTTPStream(uRL));
        this.mStream = null;
    }

    public BlockCompressedInputStream(SeekableStream seekableStream) {
        this.mFile = seekableStream;
        this.mStream = null;
    }

    public void setCheckCrcs(boolean bl) {
        this.blockGunzipper.setCheckCrcs(bl);
    }

    @Override
    public int available() throws IOException {
        if (this.mCurrentBlock == null || this.mCurrentOffset == this.mCurrentBlock.length) {
            this.readBlock();
        }
        if (this.mCurrentBlock == null) {
            return 0;
        }
        return this.mCurrentBlock.length - this.mCurrentOffset;
    }

    @Override
    public void close() throws IOException {
        if (this.mFile != null) {
            this.mFile.close();
            this.mFile = null;
        } else if (this.mStream != null) {
            this.mStream.close();
            this.mStream = null;
        }
        this.mFileBuffer = null;
        this.mCurrentBlock = null;
    }

    @Override
    public int read() throws IOException {
        return this.available() > 0 ? this.mCurrentBlock[this.mCurrentOffset++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public String readLine() throws IOException {
        int n = this.available();
        if (n == 0) {
            return null;
        }
        if (null == this.buf) {
            this.buf = new ByteArrayOutputStream(8192);
        }
        this.buf.reset();
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            int n2 = this.mCurrentOffset;
            int n3 = 0;
            while (n-- > 0) {
                byte by;
                if ((by = this.mCurrentBlock[n2++]) == 10) {
                    bl = true;
                    break;
                }
                if (bl2) {
                    --n2;
                    bl = true;
                    break;
                }
                if (by == 13) {
                    bl2 = true;
                    continue;
                }
                ++n3;
            }
            if (this.mCurrentOffset < n2) {
                this.buf.write(this.mCurrentBlock, this.mCurrentOffset, n3);
                this.mCurrentOffset = n2;
            }
            if ((n = this.available()) != 0) continue;
            bl = true;
        }
        return this.buf.toString();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        while (n2 > 0) {
            int n4 = this.available();
            if (n4 == 0) {
                if (n3 != n2) break;
                return -1;
            }
            int n5 = Math.min(n2, n4);
            System.arraycopy(this.mCurrentBlock, this.mCurrentOffset, byArray, n, n5);
            this.mCurrentOffset += n5;
            n += n5;
            n2 -= n5;
        }
        return n3 - n2;
    }

    public void seek(long l) throws IOException {
        int n;
        if (this.mFile == null) {
            throw new IOException("Cannot seek on stream based file");
        }
        long l2 = BlockCompressedFilePointerUtil.getBlockAddress(l);
        int n2 = BlockCompressedFilePointerUtil.getBlockOffset(l);
        if (this.mBlockAddress == l2 && this.mCurrentBlock != null) {
            n = this.mCurrentBlock.length;
        } else {
            this.mFile.seek(l2);
            this.mBlockAddress = l2;
            this.mLastBlockLength = 0;
            this.readBlock();
            n = this.available();
        }
        if (n2 > n || n2 == n && !this.eof()) {
            throw new IOException("Invalid file pointer: " + l);
        }
        this.mCurrentOffset = n2;
    }

    private boolean eof() throws IOException {
        if (this.mFile.eof()) {
            return true;
        }
        return this.mFile.length() - (this.mBlockAddress + (long)this.mLastBlockLength) == (long)BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK.length;
    }

    public long getFilePointer() {
        if (this.mCurrentOffset == this.mCurrentBlock.length) {
            return BlockCompressedFilePointerUtil.makeFilePointer(this.mBlockAddress + (long)this.mLastBlockLength, 0);
        }
        return BlockCompressedFilePointerUtil.makeFilePointer(this.mBlockAddress, this.mCurrentOffset);
    }

    public static long getFileBlock(long l) {
        return BlockCompressedFilePointerUtil.getBlockAddress(l);
    }

    public static boolean isValidFile(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new RuntimeException("Cannot test non-buffered stream");
        }
        inputStream.mark(18);
        byte[] byArray = new byte[18];
        int n = BlockCompressedInputStream.readBytes(inputStream, byArray, 0, 18);
        inputStream.reset();
        return n == 18 && BlockCompressedInputStream.isValidBlockHeader(byArray);
    }

    private static boolean isValidBlockHeader(byte[] byArray) {
        return byArray[0] == 31 && (byArray[1] & 0xFF) == 139 && (byArray[3] & 4) != 0 && byArray[10] == 6 && byArray[12] == 66 && byArray[13] == 67;
    }

    private void readBlock() throws IOException {
        int n;
        if (this.mFileBuffer == null) {
            this.mFileBuffer = new byte[65536];
        }
        if ((n = this.readBytes(this.mFileBuffer, 0, 18)) == 0) {
            this.mCurrentOffset = 0;
            this.mBlockAddress += (long)this.mLastBlockLength;
            this.mCurrentBlock = new byte[0];
            return;
        }
        if (n != 18) {
            throw new IOException("Premature end of file");
        }
        int n2 = this.unpackInt16(this.mFileBuffer, 16) + 1;
        if (n2 < 18 || n2 > this.mFileBuffer.length) {
            throw new IOException("Unexpected compressed block length: " + n2);
        }
        int n3 = n2 - 18;
        n = this.readBytes(this.mFileBuffer, 18, n3);
        if (n != n3) {
            throw new FileTruncatedException("Premature end of file");
        }
        this.inflateBlock(this.mFileBuffer, n2);
        this.mCurrentOffset = 0;
        this.mBlockAddress += (long)this.mLastBlockLength;
        this.mLastBlockLength = n2;
    }

    private void inflateBlock(byte[] byArray, int n) throws IOException {
        int n2 = this.unpackInt32(byArray, n - 4);
        byte[] byArray2 = this.mCurrentBlock;
        this.mCurrentBlock = null;
        if (byArray2 == null || byArray2.length != n2) {
            try {
                byArray2 = new byte[n2];
            }
            catch (NegativeArraySizeException negativeArraySizeException) {
                throw new RuntimeException("BGZF file has invalid uncompressedLength: " + n2, negativeArraySizeException);
            }
        }
        this.blockGunzipper.unzipBlock(byArray2, byArray, n);
        this.mCurrentBlock = byArray2;
    }

    private int readBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.mFile != null) {
            return BlockCompressedInputStream.readBytes(this.mFile, byArray, n, n2);
        }
        if (this.mStream != null) {
            return BlockCompressedInputStream.readBytes(this.mStream, byArray, n, n2);
        }
        return 0;
    }

    private static int readBytes(SeekableStream seekableStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2 && (n4 = seekableStream.read(byArray, n + n3, n2 - n3)) > 0; n3 += n4) {
        }
        return n3;
    }

    private static int readBytes(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n + n3, n2 - n3)) > 0; n3 += n4) {
        }
        return n3;
    }

    private int unpackInt16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private int unpackInt32(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    public static FileTermination checkTermination(File file) throws IOException {
        long l = file.length();
        if (l < (long)BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK.length) {
            return FileTermination.DEFECTIVE;
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            randomAccessFile.seek(l - (long)BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK.length);
            byte[] byArray = new byte[BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK.length];
            randomAccessFile.readFully(byArray);
            if (Arrays.equals(byArray, BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK)) {
                FileTermination fileTermination = FileTermination.HAS_TERMINATOR_BLOCK;
                return fileTermination;
            }
            int n = (int)Math.min(l, 65536L);
            byArray = new byte[n];
            randomAccessFile.seek(l - (long)n);
            randomAccessFile.read(byArray);
            for (int i = byArray.length - BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK.length; i >= 0; --i) {
                if (!BlockCompressedInputStream.preambleEqual(BlockCompressedStreamConstants.GZIP_BLOCK_PREAMBLE, byArray, i, BlockCompressedStreamConstants.GZIP_BLOCK_PREAMBLE.length)) continue;
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, i + BlockCompressedStreamConstants.GZIP_BLOCK_PREAMBLE.length, 4);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                int n2 = byteBuffer.getShort() & 0xFFFF;
                if (byArray.length - i == n2 + 1) {
                    FileTermination fileTermination = FileTermination.HAS_HEALTHY_LAST_BLOCK;
                    return fileTermination;
                }
                FileTermination fileTermination = FileTermination.DEFECTIVE;
                return fileTermination;
            }
            FileTermination fileTermination = FileTermination.DEFECTIVE;
            return fileTermination;
        }
    }

    private static boolean preambleEqual(byte[] byArray, byte[] byArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == byArray2[i + n]) continue;
            return false;
        }
        return true;
    }

    public static enum FileTermination {
        HAS_TERMINATOR_BLOCK,
        HAS_HEALTHY_LAST_BLOCK,
        DEFECTIVE;

    }
}

