% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthesizer.R
\name{make_synthesizer}
\alias{make_synthesizer}
\alias{make_synthesizer.numeric}
\alias{make_synthesizer.integer}
\alias{make_synthesizer.logical}
\alias{make_synthesizer.factor}
\alias{make_synthesizer.character}
\alias{make_synthesizer.ts}
\alias{make_synthesizer.data.frame}
\title{Create a function that generates synthetic data}
\usage{
make_synthesizer(x, ...)

\method{make_synthesizer}{numeric}(x, ...)

\method{make_synthesizer}{integer}(x, ...)

\method{make_synthesizer}{logical}(x, ...)

\method{make_synthesizer}{factor}(x, ...)

\method{make_synthesizer}{character}(x, ...)

\method{make_synthesizer}{ts}(x, ...)

\method{make_synthesizer}{data.frame}(x, rankcor = 1, ...)
}
\arguments{
\item{x}{\code{[vector|data.frame]} Template data to be synthesized.}

\item{...}{arguments passed to other methods}

\item{rankcor}{\code{[numeric]} in \eqn{(0,1]} The correlations between the ranks of
the real data and synthetic data. Either a single
number or a vector of the form \code{c("variable1"=x1,...)}. Only used
if \code{x} is a data frame.}
}
\value{
A \code{function} accepting a single integer argument: the number
        of synthesized values or records to return.
}
\description{
Create a function that accepts a non-negative integer \code{n}, and
that returns synthetic data sampled from the emperical (multivariate)
distribution of \code{x}.
}
\examples{
synth <- make_synthesizer(cars$speed)
synth(10)


synth <- make_synthesizer(iris)
synth(6)
synth(150)
synth(250)

}
\seealso{
Other synthesis: 
\code{\link{synthesize}()}
}
\concept{synthesis}
