% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.getSeasons.R
\name{trakt.getSeasons}
\alias{trakt.getSeasons}
\title{Get a show's season information}
\usage{
trakt.getSeasons(target, extended = "full,images", dropspecials = TRUE)
}
\arguments{
\item{target}{The \code{slug} of the show requested}

\item{extended}{Defaults to \code{full,images} to get season posters. Can be
\code{min}, \code{images}, \code{full}, \code{full,images}}

\item{dropspecials}{If \code{TRUE} (default), special episodes (listed as 'season 0') are dropped}
}
\value{
A \code{data.frame} containing season details (nested in \code{list} objects)
}
\description{
\code{trakt.getSeasons} pulls season data.
Get details for a show's seasons, e.g. how many seasons there are, how many epsiodes
each season has, and season posters.
See \href{http://docs.trakt.apiary.io/#introduction/extended-info}{the API docs} for possible values of
\code{extended} to customize output amount.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/seasons/summary}{the trakt API docs}
for further info
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
breakingbad.seasons <- trakt.getSeasons("breaking-bad", extended = "min")
}
}
\seealso{
Other show: \code{\link{trakt.getEpisodeData}};
  \code{\link{trakt.getFullShowData}};
  \code{\link{trakt.show.people}};
  \code{\link{trakt.show.related}};
  \code{\link{trakt.show.season}};
  \code{\link{trakt.show.stats}};
  \code{\link{trakt.show.summary}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.trending}}
}

