% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPmodel.R
\name{TPmodel}
\alias{TPmodel}
\title{Function to create a JAGS-based Bayesian model to calculate trophic position}
\usage{
TPmodel(data = NULL, model.string = NULL, n.chains = 2, n.adapt = 10000,
  quiet = FALSE, ...)
}
\arguments{
\item{data}{a list containing the data.}

\item{model.string}{model string containing a description of the model.}

\item{n.chains}{number of parallel chains for the model.}

\item{n.adapt}{number of iterations for adaptation (initial sampling phase)}

\item{quiet}{logical value to indicate whether messages generated during
compilation will be suppressed, as well as the progress bar during
adaptation.}

\item{...}{additional arguments passed to \code{\link[rjags]{jags.model}}.}
}
\value{
\code{TPmodel} returns an object inheriting from class jags which can
  be used to generate dependent samples from the posterior distribution of
  the parameters
}
\description{
This function is a wrapper of \code{\link[rjags]{jags.model}}. It receives an
isotopeData class object containing the data, a model string returned by
either \code{\link{jagsOneBaseline}}, \code{\link{jagsTwoBaselines}},
\code{\link{jagsTwoBaselinesFull}} or \code{\link{jagsBayesianModel}}, and
creates a JAGS model object.
}
\examples{
isotopeData <- generateTPData()
model.string <- jagsBayesianModel()
model <- TPmodel(data = isotopeData, model.string = model.string,
n.adapt = 500)
}
