% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTwoDistributions.R
\name{compareTwoDistributions}
\alias{compareTwoDistributions}
\title{Function to compare two distributions and test a hypothesis, in a Bayesian
context}
\usage{
compareTwoDistributions(dist1 = NULL, dist2 = NULL, test = "<=",
  sample = NULL, round = 3, ...)
}
\arguments{
\item{dist1}{A collection of numerical values (posterior distribution).}

\item{dist2}{A collection of numerical values (posterior distribution).}

\item{test}{A logical operator which states what to test for. Might be "<",
"<=", ">" or ">=".}

\item{sample}{If sample is numeric, it will take 'sample' elements of each of
the distributions.}

\item{round}{integer to indicate number of decimals kept.}

\item{...}{extra arguments are passed to compareTwoDistributions().}
}
\value{
probability given sum(dist1 "test" dist2) / length(dist1)
}
\description{
Function to compare two distributions and test a hypothesis, in a Bayesian
context
}
\examples{
a <- rnorm(100, 2, 0.1)
b <- rnorm(100, 1.8, 0.1)
compareTwoDistributions(a, b)

}
