% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credibilityIntervals.R
\name{credibilityIntervals}
\alias{credibilityIntervals}
\title{Plot credibility intervals and central tendency descriptor from posterior
distributions of trophic position and/or alpha parameter}
\usage{
credibilityIntervals(df, x = "consumer", plotAlpha = TRUE, legend = NULL,
  legendAlpha = NULL, y1 = "mode", y1min = "lower", y1max = "upper",
  y1lim = NULL, y2 = "alpha.mode", y2min = "alpha.lower",
  y2max = "alpha.upper", xlab = "Bayesian models",
  ylab1 = "Posterior trophic position", ylab2 = "Posterior alpha",
  group_by = NULL, scale_colour_manual = NULL, labels = NULL,
  plot = TRUE, ...)
}
\arguments{
\item{df}{data frame with at least 4 columns, a grouping variable, maximum,
minimum and a central tendency descriptor (median, mode, etc.).}

\item{x}{string defining the grouping variable.}

\item{plotAlpha}{logical. If TRUE it expects that the data frame has at least
7 columns, another descriptor of central tendency, its maximum and minimum.}

\item{legend}{list, position of the legend if not NULL, e.g. c(0.8, 0.8).}

\item{legendAlpha}{list, position of the legend for the alpha plot, if not
NULL, e.g. c(0.8, 0.8).}

\item{y1}{string of the column with the central tendency descriptor of
trophic position. By default, is the mode.}

\item{y1min}{lower value plotted for trophic position. For the 95%
credibility interval, this value would be 0.025 percentile.}

\item{y1max}{higher value plotted for trophic position. For the 95%
credibility interval, this value would be 0.975 percentile.}

\item{y1lim}{vector of length 2, with limits of the y axis of trophic
position.}

\item{y2}{string of the column with the central tendency descriptor of alpha.}

\item{y2min}{lower value plotted for alpha. For the 95% credibility interval,
this value would be percentile 0.025.}

\item{y2max}{higher value plotted for alpha. For the 95% credibility
interval, this value would be percentile 0.0975.}

\item{xlab}{string of the label of the X axis.}

\item{ylab1}{string of the label of Y1 axis (trophic position).}

\item{ylab2}{string of the label of Y2 axis (alpha).}

\item{group_by}{grouping variable (factor) in case of using colours.}

\item{scale_colour_manual}{a list of colours (ggplot2 syntaxis) to use with
group_by.}

\item{labels}{string, manual labels for the x axis.}

\item{plot}{logical, by default TRUE. In case of saving the output as a
variable, the user can decide not to plot the output.}

\item{...}{additional parameters passed to credibilityIntervals().}
}
\value{
a gtable (if alpha is plotted) with two ggplot2 objects or a ggplot2
  object (if alpha is not plotted)
}
\description{
This function plots a data frame in ggplot2 format (variables in columns,
observations in rows), likely returned by the functions
\code{\link{multiModelTP}} and \code{\link{multiSpeciesTP}}. This is
especially useful when there are several species or communities to compare,
and a combined plot is preferred.
}
\examples{
isotopeData <- generateTPData()
models <- multiModelTP(isotopeData, n.adapt = 200, n.iter = 200,
burnin = 200)
credibilityIntervals(models$gg, x = "model")
}
