% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab-network.R
\name{tabnet_nn}
\alias{tabnet_nn}
\title{TabNet Model Architecture}
\usage{
tabnet_nn(
  input_dim,
  output_dim,
  n_d = 8,
  n_a = 8,
  n_steps = 3,
  gamma = 1.3,
  cat_idxs = c(),
  cat_dims = c(),
  cat_emb_dim = 1,
  n_independent = 2,
  n_shared = 2,
  epsilon = 1e-15,
  virtual_batch_size = 128,
  momentum = 0.02,
  mask_type = "sparsemax"
)
}
\arguments{
\item{input_dim}{Initial number of features.}

\item{output_dim}{Dimension of network output examples : one for regression, 2 for
binary classification etc.. Vector of those dimensions in case of multi-output.}

\item{n_d}{Dimension of the prediction  layer (usually between 4 and 64).}

\item{n_a}{Dimension of the attention  layer (usually between 4 and 64).}

\item{n_steps}{Number of successive steps in the network (usually between 3 and 10).}

\item{gamma}{Float above 1, scaling factor for attention updates (usually between 1 and 2).}

\item{cat_idxs}{Index of each categorical column in the dataset.}

\item{cat_dims}{Number of categories in each categorical column.}

\item{cat_emb_dim}{Size of the embedding of categorical features if int, all categorical
features will have same embedding size if list of int, every corresponding feature will have
specific size.}

\item{n_independent}{Number of independent GLU layer in each GLU block of the encoder.}

\item{n_shared}{Number of independent GLU layer in each GLU block of the encoder.}

\item{epsilon}{Avoid log(0), this should be kept very low.}

\item{virtual_batch_size}{Batch size for Ghost Batch Normalization.}

\item{momentum}{Float value between 0 and 1 which will be used for momentum in all batch norm.}

\item{mask_type}{Either "sparsemax" or "entmax" : this is the masking function to use.}
}
\description{
This is a \code{nn_module} representing the TabNet architecture from
\href{https://arxiv.org/abs/1908.07442}{Attentive Interpretable Tabular Deep Learning}.
}
