% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_diceleraas.R
\docType{methods}
\name{plot_diceleraas}
\alias{plot_diceleraas}
\alias{plot_diceleraas-method}
\alias{plot_diceleraas,matrix-method}
\alias{plot_diceleraas,data.frame-method}
\title{Dice-Leraas Diagram}
\usage{
plot_diceleraas(object, ...)

\S4method{plot_diceleraas}{matrix}(object)

\S4method{plot_diceleraas}{data.frame}(object)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each class).}

\item{...}{Currently not used.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
Plots a Dice-Leraas diagram.
}
\details{
In a Dice-Leraas diagram, the horizontal line represents the range of data
(min-max) and the small vertical line indicates the mean. The black
rectangle is twice the standard error on the mean, while the white rectangle
is one standard deviation on either side of the mean.
}
\examples{
## Ceramic data
## (data from Desachy 2004)
data("compiegne", package = "folio")

## Plot a Dice-Leraas diagram
plot_diceleraas(compiegne)
}
\references{
Dice, L. R., & Leraas, H. J. (1936). A Graphic Method for Comparing Several
Sets of Measurements. \emph{Contributions from the Laboratory of Vertebrate
Genetics}, 3: 1-3.

Hubbs, C. L., & C. Hubbs (1953). An Improved Graphical Analysis and
Comparison of Series of Samples. \emph{Systematic Biology}, 2(2): 49-56.
\doi{10.2307/sysbio/2.2.49}.

Simpson, G. G., Roe, A., & Lewontin, R. C. \emph{Quantitative Zoology}.
New York: Harcourt, Brace and Company, 1960.
}
\seealso{
Other plot methods: 
\code{\link{matrigraph}()},
\code{\link{plot_bertin}()},
\code{\link{plot_diversity}},
\code{\link{plot_ford}()},
\code{\link{plot_heatmap}()},
\code{\link{plot_rank}()},
\code{\link{plot_spot}()},
\code{\link{seriograph}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
