% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/seriograph.R
\docType{methods}
\name{seriograph}
\alias{seriograph}
\alias{seriograph-method}
\alias{eppm}
\alias{eppm-method}
\alias{eppm,matrix-method}
\alias{eppm,data.frame-method}
\alias{seriograph,matrix-method}
\alias{seriograph,data.frame-method}
\title{Seriograph}
\usage{
seriograph(object, ...)

eppm(object, ...)

\S4method{eppm}{matrix}(object)

\S4method{eppm}{data.frame}(object)

\S4method{seriograph}{matrix}(
  object,
  weights = FALSE,
  fill = "darkgrey",
  border = NA,
  axes = TRUE,
  ...
)

\S4method{seriograph}{data.frame}(
  object,
  weights = FALSE,
  fill = "darkgrey",
  border = NA,
  axes = TRUE,
  ...
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table).}

\item{...}{Currently not used.}

\item{weights}{A \code{\link{logical}} scalar: should the row sums be displayed?}

\item{fill}{The color for filling the bars.}

\item{border}{The color to draw the borders.}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}
}
\value{
\itemize{
\item \code{seriograph()} is called it for its side-effects: it results in a graphic
being displayed (invisibly returns \code{object}).
\item \code{eppm()} returns a \code{\link{numeric}} \code{\link{matrix}}.
}
}
\description{
\itemize{
\item \code{seriograph()} produces a Ford diagram highlighting the relationships
between rows and columns.
\item \code{eppm()} computes for each cell of a numeric matrix the positive
difference from the column mean percentage.
}
}
\details{
The positive difference from the column mean percentage (in french "écart
positif au pourcentage moyen", EPPM) represents a deviation from the
situation of statistical independence. As independence can be interpreted as
the absence of relationships between types and the chronological order of
the assemblages, EPPM is a useful tool to explore significance
of relationship between rows and columns related to seriation (Desachy
2004).

\code{seriograph()} superimposes the frequencies (grey) and EPPM values (black)
for each row-column pair in a Ford diagram.
}
\examples{
## Data from Desachy 2004
data("compiegne", package = "folio")

## Seriograph
seriograph(compiegne)
seriograph(compiegne, weights = TRUE)

## Compute EPPM
counts_eppm <- eppm(compiegne)
plot_heatmap(counts_eppm, col = khroma::color("YlOrBr")(12))
}
\references{
Desachy, B. (2004). Le sériographe EPPM: un outil informatisé de sériation
graphique pour tableaux de comptages. \emph{Revue archéologique de Picardie},
3(1), 39-56. \doi{10.3406/pica.2004.2396}.
}
\seealso{
\code{\link[=plot_ford]{plot_ford()}}

Other plot methods: 
\code{\link{matrigraph}()},
\code{\link{plot_bertin}()},
\code{\link{plot_diceleraas}()},
\code{\link{plot_diversity}},
\code{\link{plot_ford}()},
\code{\link{plot_heatmap}()},
\code{\link{plot_rank}()},
\code{\link{plot_rarefaction}},
\code{\link{plot_spot}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
