% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{resample}
\alias{resample}
\alias{resample-method}
\alias{resample,numeric-method}
\title{Resample}
\usage{
resample(object, ...)

\S4method{resample}{numeric}(object, do, n, size = sum(object), ..., f = NULL)
}
\arguments{
\item{object}{A \code{\link{numeric}} vector of count data (absolute frequencies).}

\item{...}{Extra arguments passed to \code{do}.}

\item{do}{A \code{\link{function}} that takes \code{object} as an argument
and returns a single numeric value.}

\item{n}{A non-negative \code{\link{integer}} specifying the number of bootstrap
replications.}

\item{size}{A non-negative \code{\link{integer}} specifying the sample size.}

\item{f}{A \code{\link{function}} that takes a single numeric vector (the result of
\code{do}) as argument.}
}
\value{
If \code{f} is \code{NULL}, \code{resample()} returns the \code{n} values of \code{do}. Else,
returns the result of \code{f} applied to the \code{n} values of \code{do}.
}
\description{
Simulates observations from a multinomial distribution.
}
\examples{
## Sample observations from a multinomial distribution
x <- sample(1:100, 50, TRUE)
resample(x, do = median, n = 100)

## Estimate the 25th, 50th and 95th percentiles
quant <- function(x) { quantile(x, probs = c(0.25, 0.50, 0.75)) }
resample(x, n = 100, do = median, f = quant)
}
\seealso{
\code{\link[stats:Multinom]{stats::rmultinom()}}

Other resampling methods: 
\code{\link{bootstrap}()},
\code{\link{jackknife}()}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
