% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_classes.R
\name{tab_plot}
\alias{tab_plot}
\title{Print a tabxplor table as plot}
\usage{
tab_plot(
  tabs,
  theme = c("light", "dark"),
  color_type = NULL,
  html_24_bit = NULL,
  color_legend = TRUE,
  caption = NULL,
  wrap_rows = 35,
  wrap_cols = 14,
  whitespace_only = TRUE
)
}
\arguments{
\item{tabs}{A table made with \code{\link{tab}} or \code{\link{tab_many}}.}

\item{theme}{By default, a white table with black text, Set to \code{"dark"} for a
black table with white text.}

\item{color_type}{Set to \code{"text"} to color the text, \code{"bg"} to color the
background. By default it takes \code{getOption("tabxplor.color_style_type")}.}

\item{html_24_bit}{Should specific 24bits colors palettes be used ? Default to
\code{getOption("tabxplor.color_html_24_bit")}}

\item{color_legend}{Print colors legend below the table ?}

\item{caption}{The table caption.}

\item{wrap_rows}{By default, rownames are wrapped when larger than 30 characters.}

\item{wrap_cols}{By default, colnames are wrapped when larger than 12 characters.}

\item{whitespace_only}{Set to \code{FALSE} to wrap also on non whitespace characters.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object to be printed in the
\code{RStudio} Plots pane or exported as image, using \code{\link[ggpubr]{ggtexttable}}.
}
\description{
Print a tabxplor table as plot
}
\examples{
\donttest{
tab(forcats::gss_cat, race, marital, pct = "row", color = "diff") |>
  tab_plot()
}

}
