% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto_tailplot.R
\name{pareto_tail}
\alias{pareto_tail}
\title{Estimate of tail functional t and confidence intervals for t and alpha}
\usage{
pareto_tail(
  x,
  u,
  confint = FALSE,
  method = c("unbiased", "bootstrap", "jackknife"),
  R = 1000,
  conf.level = 0.95,
  alpha.max = 100
)
}
\arguments{
\item{x}{a vector containing the sample data.}

\item{u}{the threshold for the computation of t.}

\item{confint}{a boolean value indicating whether the confidence interval should be computed.}

\item{method}{the method used for computing the confidence intervals (options include unbiased variance estimator, jackknife, and bootstrap).}

\item{R}{the number of the bootstrap replicates.}

\item{conf.level}{the confidence level for the interval.}

\item{alpha.max}{the upper limit of the interval to be searched for the root in an internal routine (the default value of 100 should be increased in case of error).}
}
\value{
A matrix containing:
\item{threshold}{The value of the threshold u.}
\item{t.estimate}{Estimate of the tail functional t.}
\item{t.ci1}{The lower bound of the confidence interval for t (if \code{confint = TRUE}).}
\item{t.ci2}{The upper bound of the confidence interval for t (if \code{confint = TRUE}).}
\item{alpha}{Estimate of the shape parameter under a Pareto model.}
\item{alpha.ci1}{The lower bound of the confidence interval for alpha (if \code{confint = TRUE}).}
\item{alpha.ci2}{The upper bound of the confidence interval for alpha (if \code{confint = TRUE}).}
}
\description{
This function computes the estimate of \eqn{t} and the associated confidence interval for \eqn{t} as well as \eqn{alpha}, the corresponding shape parameter under the assumption of a Pareto model according to Klar (2024). Three methods are implemented to compute the confidence intervals: a method based on the unbiased variance estimators of the underlying U-statistics and two resampling methods (jackknife and bootstrap).
}
\details{
In Klar (2024)
the function
\deqn{
  t_X(u) 
  \;=\; 
  \mathbb{E}\!\biggl[
    \frac{\lvert X_1 - X_2 \rvert}{X_1 + X_2} 
    \;\Big|\; 
    \min\{X_1, X_2\} \,\ge u
  \biggr]
}
is proposed as a tool for detecting Pareto-type tails, where \eqn{X_1, X_2, X}
are \eqn{i.i.d.} random variables from an absolutely continuous distribution supported on \eqn{[x_m,\infty)}.
Theorem 1 in Klar (2024) shows that \eqn{t_X(u)} is constant in
\eqn{u} if and only if \eqn{X} has a Pareto distribution.

The estimator \eqn{\hat{t}_n\bigl(X_{(k)}\bigr)} can be computed
recursively.  For \eqn{k = 2,\ldots,n-1},

\deqn{
  \hat{t}_n\bigl(X_{(k)}\bigr)
  \;=\;
  \frac{n-k+2}{n-k}\,\hat{t}_n\bigl(X_{(k-1)}\bigr)
  \;-\;
  \frac{1}{\binom{\,n-k+1\,}{2}}
  \sum_{j=k}^{n}
  \frac{X_{(j)} - X_{(k-1)}}{X_{(j)} + X_{(k-1)}}\,,
}

which can be evaluated efficiently starting from
\eqn{\hat{t}_n\bigl(X_{(n-1)}\bigr) = \bigl(X_{(n)} - X_{(n-1)}\bigl)/\bigl(X_{(n)} + X_{(n-1)}\bigl)}, where \eqn{X_{(k)}} denotes the \eqn{k}-th order statistic.

Confidence intervals for \eqn{t(u)} based on the following methods for variance estimation are also provided:
\itemize{
\item Unbiased variance estimator
\item Bootstrap resampling
\item Jackknife resampling
}

A two-sided \eqn{(1 - \gamma)} confidence interval
for the estimator \eqn{\hat{t}_n(u)} is :
\deqn{
  \left[
    \max\!\Bigl\{
      \hat{t}_n(u)
      \;-\;
      z_{1 - \frac{\gamma}{2}}
      \,\frac{\hat{\sigma}_{u}}{
        \sqrt{n\,U_n^{(2)}(u)}
      },
      \;0
    \Bigr\},
    \,
    \min\!\Bigl\{
      \hat{t}_n(u)
      \;+\;
      z_{1 - \frac{\gamma}{2}}
      \,\frac{\hat{\sigma}_{u}}{
        \sqrt{n\,U_n^{(2)}(u)}
      },
      \;1
    \Bigr\}
  \right],
}
where \eqn{z_{1 - \frac{\gamma}{2}} = \Phi^{-1}(1 - \tfrac{\gamma}{2})} is the appropriate quantile of the standard normal distribution, \eqn{\hat{\sigma}_u} is an estimator of the standard deviation of \eqn{c\,\hat{t}_n(u)}, for a constant c specified in section 4.1. of Klar (2024), and
\eqn{U_n^{(2)}(u)} is a U-statistic given by
\deqn{
        U_n^{(2)}(u)
        \;=\;
        \frac{2}{n\,(n-1)}
        \sum_{i = 1}^n
        (n - i)
        1\{X_{(i)} \,\ge\, u\}.
      }
}
\examples{
x <- actuar::rpareto1(1e3, shape=1, min=1)
pareto_tail(x, round( quantile(x, c(0.1, 0.5, 0.75, 0.9, 0.95, 0.99)) ), confint = FALSE) 

}
\references{
Klar, B. (2024). A Pareto tail plot without moment restrictions. \emph{The American Statistician}. \doi{https://doi.org/10.1080/00031305.2024.2413081}
}
