% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-defined-transformations.R
\name{user_transform}
\alias{user_transform}
\title{Apply user transformations depths-first.}
\usage{
user_transform(expr, env = rlang::caller_env())
}
\arguments{
\item{expr}{The expression to transform -- typically a function body.}

\item{env}{The environment where functions can be found.}
}
\value{
Rewritten expression
}
\description{
Apply user transformations depths-first.
}
\examples{
my_if_else <- function(test, if_true, if_false) {
    if (test) if_true else if_false
}
class(my_if_else) <- c("my_if_else", class(my_if_else))
transform_call.my_if_else <- function(fun, expr) {
    test <- expr[[2]]; if_true <- expr[[3]]; if_false <- expr[[4]]
    rlang::expr(if (rlang::UQ(test)) rlang::UQ(if_true) else rlang::UQ(if_false))
}

f <- function(x, y) my_if_else(x == y, x, f(y, y))
user_transform(body(f))

}
