% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cate.R
\name{cate}
\alias{cate}
\title{Conditional Average Treatment Effect estimation}
\usage{
cate(
  treatment,
  response_model,
  propensity_model,
  contrast = c(1, 0),
  data,
  nfolds = 5,
  type = "dml1",
  ...
)
}
\arguments{
\item{treatment}{formula specifying treatment and variables to condition on}

\item{response_model}{SL object}

\item{propensity_model}{SL object}

\item{contrast}{treatment contrast (default 1 vs 0)}

\item{data}{data.frame}

\item{nfolds}{Number of folds}

\item{type}{'dml1' or 'dml2'}

\item{...}{additional arguments to SuperLearner}
}
\value{
cate.targeted object
}
\description{
Conditional Average Treatment Effect estimation via Double Machine Learning
}
\examples{
sim1 <- function(n=1e4,
                 seed=NULL,
                 return_model=FALSE, ...) {
suppressPackageStartupMessages(require("lava"))
if (!is.null(seed)) set.seed(seed)
m <- lava::lvm()
regression(m, ~a) <- function(z1,z2,z3,z4,z5)
         cos(z1)+sin(z1*z2)+z3+z4+z5^2
regression(m, ~u) <- function(a,z1,z2,z3,z4,z5)
        (z1+z2+z3)*a + z1+z2+z3 + a
distribution(m, ~a) <- binomial.lvm()
if (return_model) return(m)
lava::sim(m, n, p=par)
}

d <- sim1(200)
if (require("SuperLearner",quietly=TRUE)) {
  e <- cate(a ~ z1+z2+z3, response=u~., data=d)
  e
}

}
\author{
Klaus Kähler Holst
}
