% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_glimpse.R
\name{tar_glimpse}
\alias{tar_glimpse}
\title{Visualize an abridged fast dependency graph.}
\usage{
tar_glimpse(
  targets_only = TRUE,
  allow = NULL,
  exclude = NULL,
  level_separation = NULL,
  callr_function = callr::r,
  callr_arguments = list()
)
}
\arguments{
\item{targets_only}{Logical, whether to restrict the output to just targets
(\code{FALSE}) or to also include imported global functions and objects.}

\item{allow}{Optional, define the set of allowable vertices in the graph.
Set to \code{NULL} to allow all vertices in the pipeline and environment
(default). Otherwise, you can supply symbols, a character vector, or
\code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.}

\item{exclude}{Optional, define the set of exclude vertices from the graph.
Set to \code{NULL} to exclude no vertices.
Otherwise, you can supply symbols, a character vector, or \code{tidyselect}
helpers like \code{\link[=starts_with]{starts_with()}}.}

\item{level_separation}{Numeric of length 1,
\code{levelSeparation} argument of \code{visNetwork::visHierarchicalLayout()}.
Controls the distance between hierarchical levels.
Consider changing the value if the aspect ratio of the graph
is far from 1. If \code{level_separation} is \code{NULL},
the \code{levelSeparation} argument of \code{visHierarchicalLayout()}
defaults to \code{150}.}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}
}
\value{
A \code{visNetwork} HTML widget object.
}
\description{
Analyze the pipeline defined in \verb{_targets.R}
and visualize the directed acyclic graph of targets.
Unlike \code{\link[=tar_visnetwork]{tar_visnetwork()}}, \code{tar_glimpse()} does not account for
metadata or progress information, which means the graph
renders faster. Also, \code{tar_glimpse()} omits functions and other global
objects by default (but you can include them with \code{targets_only = FALSE}).
}
\examples{
if (identical(Sys.getenv("TARGETS_INTERACTIVE_EXAMPLES"), "true")) {
tar_dir({ # Write all files to a temporary directory.
tar_script({
  tar_option_set()
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
})
tar_glimpse()
tar_glimpse(allow = starts_with("y"))
})
}
}
