% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_call.R
\name{tar_call}
\alias{tar_call}
\title{Identify the called \code{targets} function.}
\usage{
tar_call()
}
\value{
Character of length 1, name of the currently running \code{targets}
interface function. For example, suppose you have a call to
\code{tar_call()} inside a target or \verb{_targets.R}. Then if you run
\code{tar_make()}, \code{tar_call()} will return \code{"tar_make"}.
}
\description{
Get the name of the currently running \code{targets}
interface function. Returns \code{NULL} if not invoked inside
a target or \verb{_targets.R} (i.e. if not directly invoked
by \code{\link[=tar_make]{tar_make()}}, \code{\link[=tar_visnetwork]{tar_visnetwork()}}, etc.).
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_call() # NULL
tar_script({
  message("called function: ", tar_call())
  tar_target(x, tar_call())
})
tar_manifest() # prints "called function: tar_manifest"
tar_make() # prints "called function: tar_make"
tar_read(x) # "tar_make"
})
}
}
\seealso{
Other utilities: 
\code{\link{tar_active}()},
\code{\link{tar_cancel}()},
\code{\link{tar_definition}()},
\code{\link{tar_envir}()},
\code{\link{tar_group}()},
\code{\link{tar_name}()},
\code{\link{tar_path}()},
\code{\link{tar_seed}()},
\code{\link{tar_store}()}
}
\concept{utilities}
