% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_meta_download.R
\name{tar_meta_download}
\alias{tar_meta_download}
\title{download local metadata to the cloud.}
\usage{
tar_meta_download(
  verbose = TRUE,
  script = targets::tar_config_get("script"),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{verbose}{Logical of length 1, whether to print informative
console messages.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\description{
download local metadata files to the cloud location
(repository, bucket, and prefix) you set in
\code{\link[=tar_option_set]{tar_option_set()}} in \verb{_targets.R}.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
}, ask = FALSE)
tar_make()
tar_meta_download()
})
}
}
\seealso{
Other metadata: 
\code{\link{tar_meta_delete}()},
\code{\link{tar_meta_sync}()},
\code{\link{tar_meta_upload}()},
\code{\link{tar_meta}()}
}
\concept{metadata}
