% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_progress_branches.R
\name{tar_progress_branches}
\alias{tar_progress_branches}
\title{Tabulate the progress of dynamic branches.}
\usage{
tar_progress_branches(
  names = NULL,
  fields = NULL,
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{names}{Optional, names of the targets. If supplied, \code{tar_progress()}
only returns progress information on these targets.
The object supplied to \code{names} should be \code{NULL} or a
\code{tidyselect} expression like \code{\link[=any_of]{any_of()}} or \code{\link[=starts_with]{starts_with()}}
from \code{tidyselect} itself, or \code{\link[=tar_described_as]{tar_described_as()}} to select target names
based on their descriptions.}

\item{fields}{Optional, names of progress data columns to read.
Set to \code{NULL} to read all fields.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
A data frame with one row per target per progress status
and the following columns.
\itemize{
\item \code{name}: name of the pattern.
\item \code{progress}: progress status: \code{"dispatched"}, \code{"completed"},
\code{"cancelled"}, or \code{"errored"}.
\item \code{branches}: number of branches in the progress category.
\item \code{total}: total number of branches planned for the whole pattern.
Values within the same pattern should all be equal.
}
}
\description{
Read a project's target progress data for the most recent
run of the pipeline and display the tabulated status
of dynamic branches. Only the most recent record is shown.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, x, pattern = map(x)),
    tar_target(z, stopifnot(y < 1.5), pattern = map(y))
  )
}, ask = FALSE)
try(tar_make())
tar_progress_branches()
})
}
}
\seealso{
Other progress: 
\code{\link{tar_canceled}()},
\code{\link{tar_completed}()},
\code{\link{tar_dispatched}()},
\code{\link{tar_errored}()},
\code{\link{tar_poll}()},
\code{\link{tar_progress}()},
\code{\link{tar_progress_summary}()},
\code{\link{tar_skipped}()},
\code{\link{tar_watch}()},
\code{\link{tar_watch_server}()},
\code{\link{tar_watch_ui}()}
}
\concept{progress}
